set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14223213',
      '01121332',
      NULL,
      '21421114',
      '41234312',
      '31124134',
      '24120032',
      '03223210',
      '43132300',
      '32032233',
      '32312341',
      '23040043',
      '34344230',
      '23022313',
      '30012044',
      '30441013',
      NULL,
      '10231303',
      '04223231',
      '02030301',
      '41441344',
      '03301344',
      NULL,
      '42413432',
      '14012441',
      '30231012',
      '43403130',
      '44420024',
      '03140201',
      '40413031',
      '42103223',
      NULL,
      '24421441',
      '22123234',
      '43420340',
      '14442300',
      '02204340',
      NULL,
      '23024304',
      '43000042',
      '43124134',
      '33234110',
      '21210411',
      '34144114',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.426423,
      24.152477,
      3,
      NULL,
      '421142',
      NULL,
      '11-14-1984',
      ' 5-22-1989',
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      11,
      21,
      17,
      60.592832,
      151,
      ' 1- 4-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1984',
      64.823606,
      NULL,
      90,
      98,
      41,
      34,
      28.229934,
      NULL,
      65.193206,
      NULL,
      74,
      38.291209,
      '10-25-1985',
      16,
      17.538270,
      10.423580,
      56,
      63.830440,
      48.657015,
      4.191156,
      ' 8-16-1986',
      1,
      12.047576,
      ' 7- 6-1989',
      5.925050,
      3.260312,
      9.909119,
      9.630688,
      1.518755,
      1,
      NULL,
      NULL,
      NULL,
      28.307825,
      4.006037,
      0.285425,
      2.973932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      ' 4-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535258,
      86.797071,
      NULL,
      3.924685,
      80,
      NULL,
      1.600505,
      98,
      2.027497,
      6.521768,
      212,
      54.424009,
      NULL,
      NULL,
      1,
      70.946954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.887088,
      NULL,
      NULL,
      NULL,
      0.718318,
      NULL,
      1.804238,
      6.153216,
      0.390930,
      27.120090,
      2,
      25,
      0,
      NULL,
      50.522595,
      23,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.189848,
      0,
      1,
      3.379883,
      0,
      NULL,
      3.866485,
      1.036694,
      66.892191,
      NULL,
      NULL,
      NULL,
      ' 9-29-1977',
      ' 3-29-1985',
      NULL,
      ' 7- 1-1975',
      NULL);
commit;
end;
/


