set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1213',
      NULL,
      '24234441',
      '20300303',
      '40141234',
      '23223211',
      '30212404',
      '34204403',
      '02401200',
      '14101123',
      NULL,
      '03012110',
      '32202120',
      '40241113',
      '41233132',
      '33424213',
      NULL,
      NULL,
      '24314141',
      '44000313',
      '23202334',
      NULL,
      '41114412',
      '00430304',
      NULL,
      '24133141',
      '22000243',
      '11220224',
      '12023142',
      NULL,
      NULL,
      '34220131',
      '42041133',
      NULL,
      NULL,
      '44031224',
      NULL,
      '03432331',
      '24144240',
      '32114231',
      '42314140',
      '21210143',
      '24202141',
      '20241404',
      '43342034',
      '100',
      '44',
      NULL,
      NULL,
      '3240101',
      1.094802,
      81.854029,
      2,
      NULL,
      '332110',
      2.222442,
      ' 3-24-1993',
      ' 5- 0-1976',
      NULL,
      NULL,
      2.207576,
      14,
      0,
      12.104371,
      22,
      8,
      1.675426,
      3,
      32,
      NULL,
      22,
      19,
      17,
      20.154801,
      21.690355,
      7.315711,
      63.135082,
      NULL,
      NULL,
      6,
      48,
      NULL,
      0,
      39,
      118.709777,
      50,
      NULL,
      56.111058,
      93,
      ' 1-25-1998',
      18,
      15.933418,
      9,
      9,
      36.207675,
      21.146493,
      ' 7-17-1984',
      7.556966,
      NULL,
      1,
      1,
      2,
      0,
      9.558654,
      0.284970,
      0,
      0.501596,
      NULL,
      NULL,
      1.769293,
      NULL,
      0,
      NULL,
      2.916444,
      3.561054,
      2.969220,
      12.711266,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1999',
      48.732325,
      17.952977,
      34.617228,
      25,
      NULL,
      0.130755,
      ' 8-19-1976',
      0.198634,
      NULL,
      60,
      NULL,
      4,
      31,
      0,
      3.972965,
      31.353772,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1994',
      43.263603,
      111,
      NULL,
      9,
      28.247613,
      NULL,
      26.882131,
      69,
      11.026371,
      NULL,
      74,
      14,
      ' 1-18-1998',
      6.455014,
      12,
      4.143716,
      44.560979,
      37.323455,
      127,
      10.702449,
      '10- 5-1983',
      16.345780,
      4.009813,
      '10- 2-1998',
      4,
      4.453011,
      7,
      NULL,
      2.734448,
      2.278486,
      2,
      2.729919,
      1.441689,
      3.993631,
      2.892627,
      0,
      1,
      2,
      7.931925,
      0.260448,
      0.912581,
      3.890718,
      ' 7-20-1997',
      2,
      0,
      0.127461,
      NULL,
      123.878937,
      NULL,
      '11- 8-1978',
      NULL,
      NULL,
      NULL,
      27.273934,
      NULL,
      40,
      '10-21-1997',
      0.044528,
      4,
      ' 8- 8-2002',
      34,
      NULL,
      ' 1-29-1979',
      5.977008,
      0.091073,
      '10- 1-1986',
      7.221108,
      27.131156,
      ' 6-11-1983',
      0,
      NULL,
      NULL,
      '10-17-1982',
      56,
      13.026737,
      8,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1994',
      0,
      43.160124,
      3.337516,
      NULL,
      ' 7- 4-1980',
      25,
      NULL,
      166,
      ' 8-17-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.476329);
commit;
end;
/


