set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3230',
      NULL,
      '44130424',
      '31200440',
      NULL,
      '43223120',
      '11032034',
      NULL,
      '20100110',
      '13030424',
      '21144141',
      '12134342',
      '43214104',
      NULL,
      '20021204',
      '20000102',
      '30140414',
      NULL,
      '24304401',
      '10243201',
      '24340222',
      '14410301',
      NULL,
      '11042340',
      '41200212',
      '33410041',
      '01432231',
      '00311043',
      '30234413',
      '32303301',
      '24322041',
      '24431142',
      NULL,
      '21440102',
      '10432222',
      '42440103',
      '14114114',
      NULL,
      NULL,
      '11312032',
      NULL,
      NULL,
      '31002311',
      '22334443',
      NULL,
      '042',
      NULL,
      NULL,
      5,
      '2020010',
      0.199912,
      153,
      1,
      NULL,
      '140310',
      NULL,
      NULL,
      '11- 7-1975',
      NULL,
      96.841518,
      6,
      NULL,
      7,
      6.213155,
      3,
      10,
      2,
      NULL,
      25.895736,
      NULL,
      6,
      16.443630,
      NULL,
      NULL,
      9.933559,
      13,
      NULL,
      NULL,
      5.420035,
      5,
      NULL,
      9,
      0.787452,
      59.339672,
      113,
      29.506468,
      151,
      53.672173,
      123.365317,
      ' 4-14-2001',
      11,
      20,
      NULL,
      21,
      104.718747,
      148,
      ' 7-23-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375639,
      NULL,
      42.284577,
      4.501751,
      7,
      1,
      ' 8-25-1994',
      0.596789,
      1,
      157,
      0,
      0,
      47.315387,
      1.926817,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-20-1990',
      67,
      26.875804,
      57.804665,
      20,
      84.052902,
      72.292847,
      NULL,
      31,
      5,
      34,
      6.523903,
      15,
      ' 6-17-1975',
      9.706140,
      23.945480,
      19,
      22,
      43,
      5.294456,
      4,
      ' 6-11-1992',
      NULL,
      NULL,
      ' 9-26-1993',
      2,
      2.051636,
      9.806625,
      4.771215,
      1,
      5.574338,
      0,
      1.533005,
      NULL,
      7,
      1,
      1,
      5.335401,
      23,
      4,
      NULL,
      13.338765,
      0,
      ' 4-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.486702,
      NULL,
      NULL,
      NULL,
      NULL,
      5.796699,
      NULL,
      30.153225,
      ' 2-13-1979',
      10,
      5.588197,
      ' 5-15-1997',
      79.455885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      ' 7-15-1984',
      NULL,
      NULL,
      2.235022,
      NULL,
      6,
      NULL,
      NULL,
      4,
      92,
      NULL,
      46,
      '11-16-1980',
      41,
      0.516359,
      NULL,
      ' 2-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


