set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '0',
      '0',
      '0',
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '0',
      '4',
      '2',
      '2',
      NULL,
      '3',
      '0',
      '2',
      '',
      NULL,
      '',
      '0',
      NULL,
      '0',
      NULL,
      '4',
      '',
      '',
      '2',
      NULL,
      '1',
      '2',
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '44122330',
      27,
      NULL,
      '0402212',
      0,
      140.802192,
      2,
      NULL,
      '221410',
      5.616420,
      ' 9- 2-2000',
      NULL,
      25,
      240.243512,
      12,
      12.593985,
      11.244188,
      8,
      NULL,
      15,
      5.279475,
      4,
      0,
      4.002779,
      25.915626,
      4.850415,
      22,
      13.088603,
      13.904835,
      NULL,
      35,
      6,
      39.067615,
      NULL,
      52,
      10,
      1.880424,
      20.173902,
      38.992914,
      32.826395,
      43,
      63,
      0,
      ' 6-24-2001',
      26.266990,
      18.339504,
      35.524413,
      5.862191,
      NULL,
      17,
      ' 1- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      51,
      9.498433,
      10.652954,
      NULL,
      2.106864,
      ' 7- 4-1996',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      65.456269,
      NULL,
      0,
      19.623708,
      NULL,
      NULL,
      NULL,
      ' 4- 9-1981',
      57.508547,
      4.354113,
      114,
      11,
      45,
      93.193723,
      107.965740,
      53,
      52.897893,
      20.440565,
      50.014032,
      NULL,
      ' 5- 8-2000',
      18.780411,
      27.348779,
      NULL,
      34,
      72.830470,
      90.804871,
      7,
      ' 2-14-1987',
      16.080956,
      7.097115,
      '11-10-1992',
      2.359437,
      10,
      8.363029,
      7.176312,
      NULL,
      1.147737,
      3.494087,
      1.880162,
      1,
      58,
      0.393803,
      1.396252,
      0.958879,
      18,
      NULL,
      18.497295,
      1,
      NULL,
      '10-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      9.085525,
      ' 6-20-1980',
      NULL,
      NULL,
      NULL,
      24,
      ' 0-15-1986',
      NULL,
      ' 9-25-2000',
      4.444492,
      7,
      NULL,
      75,
      62.235931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4.959458,
      ' 0-20-1990',
      25,
      37.522400,
      15,
      NULL,
      1,
      NULL,
      ' 5- 2-1993',
      4.283770,
      49.657535,
      3.630529,
      39.088328,
      '10- 5-1998',
      33,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


