set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0140',
      '31243204',
      '00213211',
      NULL,
      NULL,
      '43033202',
      '02410242',
      '03413131',
      '32303412',
      '04420240',
      '14310302',
      NULL,
      '41140410',
      '21232442',
      '32044431',
      '14110340',
      '32232434',
      '03222221',
      '11424231',
      '41444240',
      NULL,
      '01411232',
      '22314130',
      NULL,
      NULL,
      '42210321',
      NULL,
      '33111324',
      '42210340',
      '31240304',
      '00243221',
      NULL,
      '30014321',
      '41234240',
      '20131144',
      '23120423',
      '12200414',
      '22424032',
      '41434400',
      '04124004',
      '10213124',
      '42202222',
      '41340321',
      '13122332',
      '12001342',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2.415155,
      0,
      1,
      NULL,
      '332040',
      NULL,
      ' 8- 4-2003',
      ' 2-23-1977',
      61,
      NULL,
      0.353493,
      5,
      NULL,
      NULL,
      4,
      11.610653,
      7,
      9,
      10.965862,
      0,
      13.866916,
      11,
      24.831180,
      13,
      8.548003,
      1.672394,
      11,
      10.423140,
      35.944080,
      4.617693,
      6,
      2.101562,
      NULL,
      55,
      98.248957,
      32,
      NULL,
      77.547080,
      153.163473,
      ' 6-10-1989',
      30.332359,
      15,
      16.176673,
      5,
      15.219424,
      51.533587,
      ' 0-21-1983',
      0.924751,
      2.271280,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.364423,
      1,
      1,
      1.573236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1974',
      18,
      36,
      NULL,
      57,
      NULL,
      45,
      NULL,
      NULL,
      69,
      20,
      15,
      0.337172,
      NULL,
      NULL,
      11,
      19,
      39.886025,
      37.339733,
      44,
      5,
      ' 4-11-1994',
      0,
      2.450189,
      ' 6- 2-1996',
      0,
      NULL,
      4.018934,
      11.455666,
      13.222392,
      1,
      NULL,
      12.540214,
      NULL,
      40,
      0.537943,
      0,
      11.038455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.786616,
      22.027184,
      12.032610,
      '11- 9-2001',
      2,
      172,
      ' 1- 6-1986',
      NULL,
      82,
      NULL,
      NULL,
      ' 0-15-1977',
      NULL,
      1.931293,
      255.818313,
      ' 1-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.804635,
      NULL,
      59,
      141.941159,
      NULL,
      8.546749,
      3.861950,
      50,
      7,
      62,
      1.038701,
      1.625249,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264488,
      2,
      124.119043,
      NULL,
      43.859644,
      102,
      100.578945,
      15,
      14.156333,
      0,
      58.069717,
      1,
      1.543085,
      3.043184,
      NULL,
      0,
      NULL,
      32.586918,
      90.867732,
      77,
      7.500274,
      29,
      37.934533,
      0,
      1.973189,
      49,
      0.360991,
      NULL,
      0,
      13.899905,
      NULL,
      56,
      3.671849,
      55.807106,
      NULL,
      1.736616,
      45,
      2.049341,
      1,
      NULL,
      NULL,
      NULL,
      16,
      52,
      9,
      NULL,
      2,
      NULL,
      6,
      1,
      NULL,
      1,
      NULL,
      NULL,
      ' 2- 9-1987',
      NULL,
      ' 6- 6-2003',
      ' 2- 5-1975',
      ' 6-24-1992',
      ' 0-15-1989',
      NULL);
commit;
end;
/


