set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433921';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3321',
      '33310324',
      NULL,
      '13413232',
      '02030204',
      '04441013',
      '11334334',
      '33124241',
      '13444042',
      '34100300',
      NULL,
      '40344213',
      '01031120',
      '40404300',
      NULL,
      NULL,
      '14032442',
      '34030133',
      '03130321',
      NULL,
      '10123103',
      '00111144',
      '41444434',
      '01244002',
      '30442034',
      '13423022',
      '22033432',
      '10042312',
      '30424412',
      '34434044',
      '14210442',
      NULL,
      '10332101',
      NULL,
      '12112021',
      '32240143',
      NULL,
      NULL,
      '13311234',
      '43203200',
      '03102104',
      '23244143',
      '01241312',
      '01332330',
      '41424400',
      '424',
      '14',
      NULL,
      NULL,
      '2012424',
      1.245569,
      0,
      1,
      NULL,
      '202323',
      2.255428,
      ' 9-25-1980',
      ' 8- 3-2001',
      135.058787,
      NULL,
      2,
      2,
      10.520940,
      13,
      28,
      12.786863,
      9.471894,
      4.216238,
      0.799870,
      7,
      13,
      2.679639,
      15,
      NULL,
      NULL,
      13.280018,
      38,
      5,
      38.874808,
      17,
      26,
      5.856171,
      1.635931,
      37,
      135,
      14.914559,
      52,
      92.769980,
      66,
      NULL,
      35.600685,
      NULL,
      1,
      NULL,
      6,
      20,
      ' 6-24-1974',
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      12,
      2,
      2,
      1,
      1,
      NULL,
      0.834345,
      4,
      0,
      1,
      0,
      NULL,
      0.794141,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1998',
      110,
      3,
      2,
      6.444498,
      NULL,
      3.223449,
      '10-13-1976',
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      76.105421,
      43.152215,
      71,
      54,
      99,
      10.851716,
      27.038733,
      NULL,
      84.277020,
      NULL,
      59.500135,
      ' 2- 3-1978',
      1.433524,
      13,
      4.106521,
      NULL,
      35.751813,
      2,
      NULL,
      ' 3-24-1999',
      8,
      NULL,
      ' 0-19-1983',
      3,
      9.001498,
      15.876647,
      5,
      4,
      0,
      NULL,
      0.059185,
      0.006196,
      NULL,
      NULL,
      5.852981,
      4,
      NULL,
      0.470732,
      7.996137,
      1,
      1.536750,
      '10-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      2.703752,
      ' 1-15-2003',
      NULL,
      NULL,
      NULL,
      32.372672,
      ' 3- 2-1986',
      39.174076,
      NULL,
      NULL,
      9.885013,
      '11- 2-1979',
      34,
      103.697681,
      NULL,
      11.530505,
      NULL,
      ' 5-23-1976',
      NULL,
      NULL,
      NULL,
      0,
      0,
      13.796846,
      ' 9-20-1976',
      24.621823,
      36,
      59,
      ' 1-10-1988',
      1,
      2,
      ' 3- 4-1974',
      10,
      130.082834,
      0,
      NULL,
      ' 8-14-1979',
      6,
      0,
      NULL,
      ' 4-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


