set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '0',
      '0',
      '3',
      '2',
      '1',
      '0',
      '0',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '4',
      '4',
      '2',
      '2',
      '0',
      '4',
      '4',
      '0',
      '0',
      '1',
      '',
      '3',
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '0',
      '',
      '',
      '4',
      '3',
      '2',
      '1',
      '1',
      '2',
      '4',
      '4',
      '3',
      '0',
      NULL,
      '440',
      '24422442',
      51.808344,
      31.304655,
      '1424440',
      NULL,
      0,
      3,
      1,
      '034424',
      4.822920,
      '11- 7-1985',
      ' 7-14-2002',
      92,
      NULL,
      29,
      7,
      23.293125,
      4,
      83,
      12,
      NULL,
      NULL,
      10.741717,
      19.326210,
      23,
      15.718289,
      3.441329,
      7,
      21,
      11.552558,
      30.416372,
      12.004310,
      49.492631,
      11,
      39,
      NULL,
      1.488335,
      61,
      13,
      73.791797,
      2,
      160,
      NULL,
      ' 2-22-1995',
      11,
      59,
      17.304406,
      6.707794,
      184.713198,
      108,
      ' 4-21-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      16,
      9.281642,
      NULL,
      NULL,
      NULL,
      '11- 2-1995',
      0.346641,
      0.040607,
      71,
      0,
      1,
      11,
      0.371500,
      3.653638,
      29.003731,
      NULL,
      NULL,
      NULL,
      ' 0-17-1994',
      NULL,
      22.567291,
      NULL,
      59,
      68.595286,
      NULL,
      76,
      NULL,
      95.274389,
      8,
      85.889719,
      45.235082,
      '11-17-2000',
      9.054089,
      NULL,
      3,
      9,
      56,
      34,
      NULL,
      NULL,
      15.209646,
      4,
      ' 8-21-1974',
      6,
      15,
      6,
      17.817787,
      9.992427,
      0.641155,
      1.720274,
      1.046736,
      1,
      68.843167,
      2.116445,
      NULL,
      16,
      22,
      NULL,
      NULL,
      0,
      1.587079,
      ' 5-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      0.020310,
      ' 7- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1980',
      NULL,
      5,
      ' 4-29-1992',
      6,
      44,
      ' 7-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      21.066572,
      ' 9-21-1981',
      46.948959,
      32.820227,
      NULL,
      ' 3-10-1996',
      1.480021,
      161,
      ' 9-10-1981',
      11.314897,
      63.818926,
      14.844536,
      29.001873,
      ' 7- 7-1989',
      34,
      NULL,
      289,
      ' 3-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


