set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '4',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '4',
      '4',
      '0',
      '0',
      '3',
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '0',
      '1',
      '0',
      '3',
      '',
      '3',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3',
      '0',
      '2',
      '0',
      '2',
      '4',
      '3',
      '2',
      '0',
      '3',
      '0',
      '024',
      '43014401',
      51,
      15,
      '4031031',
      1.697225,
      13.738812,
      NULL,
      0,
      '442041',
      NULL,
      NULL,
      ' 3-18-1989',
      3,
      NULL,
      NULL,
      12.736618,
      17.518928,
      NULL,
      59,
      0.518700,
      14,
      7,
      11,
      15.449046,
      18.012069,
      9,
      2,
      14.276645,
      14.350098,
      NULL,
      53,
      10,
      25.442631,
      7.895182,
      19,
      NULL,
      0.700340,
      NULL,
      90,
      84,
      169,
      36,
      NULL,
      NULL,
      NULL,
      6,
      8.577523,
      NULL,
      159.850077,
      170.679781,
      ' 2-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      14.010588,
      NULL,
      16.126428,
      14.862624,
      3,
      '11-20-1991',
      NULL,
      0,
      134.719257,
      0.456390,
      1.138974,
      1.997312,
      NULL,
      1.962231,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.624517,
      NULL,
      117,
      53.290162,
      25,
      2.400919,
      53,
      NULL,
      60,
      NULL,
      NULL,
      '11-23-1984',
      NULL,
      15,
      7.488551,
      1,
      64,
      3,
      10.139126,
      '11-29-1979',
      18,
      6,
      NULL,
      10,
      6.082129,
      NULL,
      NULL,
      4,
      9,
      NULL,
      4,
      0,
      60.121612,
      3.390603,
      1,
      0.541552,
      27,
      NULL,
      5.099756,
      1.884740,
      1,
      ' 0-18-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      5.128787,
      ' 9-29-1979',
      NULL,
      NULL,
      NULL,
      39,
      ' 1- 9-2003',
      15.282114,
      ' 4-27-1982',
      8,
      7,
      ' 1-22-1995',
      127,
      71,
      ' 6- 0-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      18,
      ' 0-15-1979',
      39.288762,
      19.022670,
      NULL,
      NULL,
      1.574270,
      131,
      ' 7-24-1992',
      NULL,
      7.733976,
      22.829076,
      NULL,
      ' 1-24-1987',
      53.081478,
      NULL,
      NULL,
      ' 9- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


