set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8531494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3423',
      '21213330',
      '11032434',
      NULL,
      '04330133',
      '40344211',
      NULL,
      NULL,
      '24432321',
      '12032112',
      '13340230',
      '03201130',
      '00043411',
      '43223012',
      '01302312',
      '04134402',
      '13142243',
      '32423334',
      '30203241',
      '31422000',
      '02334420',
      '04224130',
      '13201324',
      '31103302',
      '22331124',
      NULL,
      NULL,
      '33103000',
      '20330022',
      '14443204',
      NULL,
      '13421123',
      '00021202',
      '00324321',
      '10132040',
      '23442430',
      '33213041',
      '13133220',
      '03000300',
      '12232424',
      NULL,
      '31433232',
      NULL,
      '23410424',
      '01102201',
      '',
      '',
      NULL,
      NULL,
      NULL,
      1.381775,
      0,
      1,
      NULL,
      NULL,
      1.536523,
      NULL,
      ' 1-19-1985',
      95,
      NULL,
      2.251096,
      1.049642,
      12,
      10.245748,
      20,
      7.465797,
      12,
      12,
      21,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      10.532334,
      31,
      7.627292,
      24,
      6.550372,
      4,
      5.958329,
      NULL,
      10.827740,
      82,
      NULL,
      NULL,
      36.284107,
      NULL,
      '10-11-1989',
      6.484158,
      12,
      2.931581,
      5,
      32.888457,
      27.025786,
      ' 4-21-1979',
      0,
      0.331296,
      5.886487,
      23.839139,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317956,
      NULL,
      11,
      3,
      1.006720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-1981',
      18.819589,
      4,
      70.979173,
      43,
      73.629616,
      6.833821,
      8.962784,
      76.953136,
      0.146573,
      17.514121,
      37,
      3.182052,
      ' 0- 8-1990',
      23,
      8,
      NULL,
      74,
      21,
      132.013018,
      13,
      '10-26-1979',
      3.994182,
      1,
      ' 2-15-1987',
      1.708875,
      9,
      2,
      4,
      9,
      NULL,
      NULL,
      0.977800,
      NULL,
      7.457124,
      23.695591,
      1.290423,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.081472,
      20,
      NULL,
      ' 2- 2-1998',
      11.840490,
      202.780408,
      ' 8-12-1974',
      7.280264,
      44.022510,
      6.108165,
      110.471279,
      ' 5-21-1975',
      12,
      NULL,
      47.807938,
      ' 4-19-1993',
      NULL,
      NULL,
      NULL,
      37,
      28.870613,
      26,
      22,
      15,
      NULL,
      47,
      58.947059,
      15,
      2,
      1,
      30,
      1.106751,
      0.594451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239079,
      NULL,
      13,
      1,
      285.382355,
      26.813538,
      31,
      NULL,
      0,
      10,
      NULL,
      1,
      1.204399,
      5.636003,
      1,
      1,
      6.136918,
      29.965190,
      14,
      9,
      39.656264,
      NULL,
      6.357600,
      1.295089,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2.559477,
      31,
      NULL,
      NULL,
      1.737310,
      NULL,
      6.563558,
      16,
      0,
      NULL,
      17,
      28.797608,
      17.977338,
      36,
      NULL,
      14,
      3.114276,
      0,
      8,
      0,
      2.586019,
      1.655013,
      3.504273,
      NULL,
      '10- 2-1978',
      ' 8-23-1985',
      ' 6-29-1987',
      ' 6-10-2003',
      NULL,
      ' 8-21-1995',
      NULL);
commit;
end;
/


