set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923979';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0313',
      '20401003',
      '02442443',
      NULL,
      NULL,
      NULL,
      NULL,
      '41034123',
      NULL,
      '24011213',
      NULL,
      '02304310',
      '01301240',
      '20322340',
      '43044102',
      NULL,
      '32344021',
      NULL,
      '42223444',
      '11420211',
      '21022241',
      '02422204',
      NULL,
      NULL,
      '43020243',
      '04403333',
      NULL,
      '44200220',
      '20034341',
      NULL,
      '00233022',
      '04211111',
      '40421401',
      '23132040',
      '04104431',
      '42002341',
      '03021141',
      '42411322',
      '20341231',
      '23230204',
      '03024111',
      '00334431',
      NULL,
      '03220420',
      '21300303',
      '',
      '',
      NULL,
      NULL,
      '0123044',
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.636802,
      '10-25-1999',
      ' 9-15-1985',
      38,
      NULL,
      20.705209,
      10.919528,
      9.520619,
      6,
      NULL,
      11.453847,
      NULL,
      11.621069,
      19.988731,
      11.025713,
      6.299762,
      14.909534,
      9.991446,
      NULL,
      0.086066,
      2.618981,
      29,
      1.181554,
      NULL,
      6,
      NULL,
      6,
      NULL,
      89,
      95.210582,
      NULL,
      104.612195,
      60,
      100.964720,
      ' 1-10-2002',
      14,
      3,
      19,
      NULL,
      16.310615,
      46,
      ' 2- 0-1995',
      9,
      12.109261,
      6,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520749,
      1,
      29,
      0.764700,
      0.503881,
      2.992823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-21-1974',
      NULL,
      21,
      25.413320,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      45.912123,
      NULL,
      74,
      42.733101,
      ' 7-26-1978',
      4.607528,
      14,
      14.129157,
      0.019873,
      11.933317,
      8,
      NULL,
      NULL,
      9,
      9.797548,
      ' 6-26-1987',
      11,
      2,
      NULL,
      NULL,
      10.224744,
      7.870968,
      NULL,
      NULL,
      NULL,
      12,
      0.717055,
      1.265213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.182796,
      2.344721,
      7.608907,
      NULL,
      1.660941,
      276.225268,
      ' 6- 5-1975',
      9.504976,
      61.131440,
      3,
      43.591003,
      '11-17-1987',
      NULL,
      1.829570,
      NULL,
      ' 4-26-2002',
      NULL,
      NULL,
      NULL,
      5.874392,
      82.785303,
      56.666741,
      77,
      37.117885,
      NULL,
      39.831261,
      2,
      1.255275,
      31.911387,
      3.489640,
      74,
      0,
      1,
      19,
      NULL,
      NULL,
      NULL,
      1,
      0.467433,
      93,
      0.384264,
      5,
      449.383219,
      NULL,
      17.083538,
      76.479030,
      1,
      36,
      0.847217,
      1.079390,
      1.960295,
      1.669702,
      3.736995,
      NULL,
      56.493385,
      NULL,
      40,
      8.027652,
      61,
      11,
      2.548142,
      0,
      7,
      1,
      NULL,
      3.394420,
      7.261680,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      40.409018,
      3.521745,
      NULL,
      3,
      61.639079,
      NULL,
      17,
      5.277439,
      11.685228,
      11,
      2.700115,
      6.246137,
      NULL,
      1.604838,
      1,
      NULL,
      62,
      ' 9- 3-1983',
      NULL,
      ' 2- 0-1981',
      '11-19-1981',
      NULL,
      ' 4- 2-1976',
      ' 4- 7-1992',
      NULL);
commit;
end;
/


