set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845877';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      '2',
      '2',
      '3',
      '3',
      '1',
      '2',
      NULL,
      '3',
      '4',
      '2',
      '2',
      '2',
      '4',
      '4',
      '0',
      '4',
      '2',
      '0',
      '2',
      '0',
      '2',
      '',
      '3',
      NULL,
      '4',
      '1',
      '1',
      '1',
      '2',
      '',
      '',
      '2',
      '0',
      '0',
      '2',
      '0',
      NULL,
      '0',
      '1',
      '0',
      '3',
      '0',
      '214',
      '24341434',
      31,
      19.967917,
      '3430000',
      1.629174,
      1,
      3,
      NULL,
      '112034',
      0,
      ' 1-27-1978',
      ' 8-19-1988',
      39,
      256.521782,
      31,
      5.553900,
      31,
      14,
      37.245382,
      0.712976,
      NULL,
      14.084841,
      20.832062,
      9.618133,
      NULL,
      17,
      2.336127,
      2,
      12,
      5.073053,
      26,
      13.118028,
      NULL,
      7,
      39,
      0,
      0.753000,
      22.089005,
      78,
      21.216105,
      121.268316,
      136,
      113,
      ' 3-26-1984',
      7.118797,
      6.111083,
      28.770699,
      12.676327,
      NULL,
      128,
      ' 3-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      13,
      8,
      NULL,
      NULL,
      5.847838,
      '10- 0-2000',
      1.223985,
      0,
      168.455901,
      0.061124,
      1,
      77,
      0.762436,
      NULL,
      95.427958,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      26,
      27,
      22,
      NULL,
      11,
      1,
      NULL,
      27.470924,
      85.528383,
      NULL,
      93.784306,
      NULL,
      7.151481,
      8.357499,
      15,
      14.316656,
      NULL,
      99,
      10.954395,
      NULL,
      3,
      NULL,
      ' 6- 6-1984',
      5,
      12.750156,
      0.147756,
      16.407713,
      2.544841,
      1,
      0,
      NULL,
      2,
      NULL,
      8,
      1,
      10.727046,
      22,
      1,
      0.678374,
      0.595416,
      1,
      ' 5- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      55.286625,
      11.846931,
      ' 5-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1995',
      19,
      ' 7- 9-1988',
      12,
      NULL,
      ' 5-16-1996',
      33,
      82.497989,
      ' 2- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17.340544,
      ' 7-21-1980',
      48,
      24.857148,
      20,
      ' 0- 6-1976',
      0.586340,
      54.210397,
      ' 7-10-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


