set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3042',
      NULL,
      '21313104',
      '21323404',
      '20144130',
      '01201341',
      '21230231',
      '04120122',
      NULL,
      '13132342',
      '41131211',
      '12310112',
      NULL,
      '04310424',
      '02234403',
      '24103210',
      NULL,
      '20212320',
      '20034421',
      '20031112',
      '40204402',
      '00011000',
      '32211124',
      '14114341',
      '12202134',
      '33220323',
      '33333403',
      '33323240',
      '20401141',
      '03240421',
      NULL,
      '42403322',
      '01114430',
      '20243200',
      '40131210',
      NULL,
      '11420424',
      '14122212',
      '34120310',
      '10433344',
      NULL,
      '43211232',
      '41000120',
      '10000330',
      '20401112',
      '',
      '',
      NULL,
      NULL,
      '4024002',
      1,
      0,
      3,
      NULL,
      '013112',
      0,
      ' 0-28-1975',
      NULL,
      66.356237,
      NULL,
      23,
      8,
      NULL,
      7.875839,
      NULL,
      2.718930,
      3,
      4.785378,
      NULL,
      2,
      0,
      3.240583,
      7,
      8,
      NULL,
      1,
      NULL,
      9,
      NULL,
      4.082622,
      20.138752,
      5,
      NULL,
      24.135372,
      71,
      11.592754,
      NULL,
      55,
      5,
      '10-21-1975',
      0,
      3,
      NULL,
      17.942667,
      69.440858,
      NULL,
      NULL,
      13.659677,
      12.167768,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.545959,
      2,
      1,
      0.915521,
      3.170809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-13-1976',
      81,
      79.306570,
      34,
      61.973533,
      NULL,
      69.320902,
      35.941535,
      57,
      15.627265,
      NULL,
      20,
      23,
      ' 7-22-1991',
      8.664736,
      2,
      1,
      13,
      NULL,
      0,
      2,
      '11-12-1997',
      6,
      NULL,
      '11-23-1982',
      NULL,
      5.822063,
      5,
      5,
      7,
      2,
      NULL,
      0,
      NULL,
      24,
      0.688428,
      1.700142,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      12,
      12.731140,
      ' 1-17-1995',
      NULL,
      NULL,
      NULL,
      3,
      46,
      4,
      27.760491,
      ' 4-14-1991',
      8.127785,
      0.565415,
      93,
      NULL,
      NULL,
      NULL,
      NULL,
      46.319524,
      97.456885,
      25,
      50.136669,
      80,
      4.683825,
      NULL,
      70,
      2,
      NULL,
      1,
      47,
      1.350214,
      0.851111,
      86.206628,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      130.554929,
      1,
      1.033331,
      364,
      59,
      NULL,
      53,
      NULL,
      NULL,
      2.897015,
      0,
      1.423144,
      1,
      1,
      1.486984,
      21.243566,
      12,
      7,
      3,
      5.119721,
      6.042939,
      1,
      1,
      2.822433,
      NULL,
      0.592129,
      3,
      0,
      0,
      61.740898,
      2,
      81.703126,
      1,
      0.267697,
      51.703116,
      2,
      1.073048,
      3.375184,
      80,
      13.926511,
      1,
      45.208805,
      5.218878,
      20.027042,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      27.334978,
      '10- 8-1982',
      ' 9-16-1982',
      NULL,
      ' 8-21-1997',
      ' 9-23-1980',
      ' 5-18-1978',
      '10-24-1980',
      NULL);
commit;
end;
/


