set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00003103',
      NULL,
      '24324132',
      NULL,
      '01304004',
      NULL,
      '01214304',
      '13231030',
      '32230113',
      '13102303',
      NULL,
      '03210210',
      '12002120',
      '30402014',
      '03414341',
      '31242010',
      NULL,
      NULL,
      NULL,
      '32142014',
      NULL,
      '00442404',
      '02204034',
      '31030210',
      '32003423',
      '33103430',
      '14000020',
      NULL,
      '13433100',
      '03422401',
      NULL,
      '11112210',
      NULL,
      '42432440',
      '02000004',
      '41044400',
      '33130402',
      '23231324',
      '34012044',
      '10233100',
      '34441213',
      '01031321',
      '22242401',
      NULL,
      '210',
      NULL,
      NULL,
      NULL,
      '0313241',
      NULL,
      NULL,
      3,
      NULL,
      '011102',
      3.653520,
      ' 5-18-2003',
      ' 4-18-1990',
      NULL,
      NULL,
      34,
      15,
      3,
      7,
      62,
      0,
      4.206444,
      10.078017,
      14.408250,
      1.835191,
      26,
      NULL,
      NULL,
      9,
      4,
      NULL,
      0.873515,
      6.388005,
      50,
      19,
      28,
      NULL,
      NULL,
      18.827264,
      193,
      NULL,
      81.758523,
      106,
      26.990944,
      ' 4- 8-1976',
      43,
      7,
      1.244310,
      26.805435,
      108,
      87,
      ' 5-24-2002',
      NULL,
      1.634846,
      1,
      1,
      0.011258,
      NULL,
      0,
      1,
      0.082397,
      0.344194,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.402741,
      0,
      0.014874,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-2003',
      47,
      1.255686,
      NULL,
      NULL,
      38,
      5,
      ' 5- 7-1987',
      0.704588,
      0,
      107.709753,
      0,
      0,
      60,
      0.337814,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1985',
      52,
      34,
      19.386810,
      22,
      8.910433,
      24,
      15.213421,
      44,
      53,
      NULL,
      0,
      63.939043,
      ' 3- 5-2003',
      5.797898,
      NULL,
      NULL,
      40.188097,
      NULL,
      2.530164,
      NULL,
      NULL,
      6.903053,
      NULL,
      ' 1-25-1989',
      3.534337,
      NULL,
      NULL,
      NULL,
      15.957094,
      4.594713,
      NULL,
      2,
      0.946850,
      30.105615,
      3.616254,
      3.551631,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      ' 7-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      22.809036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      '10-17-1986',
      40,
      NULL,
      8,
      NULL,
      ' 4-25-1989',
      NULL,
      NULL,
      NULL,
      1.079270,
      NULL,
      ' 1-26-1994',
      NULL,
      NULL,
      NULL,
      2,
      3,
      20.920168,
      ' 4-29-1984',
      5,
      NULL,
      6,
      ' 8-17-1975',
      0.955208,
      98.459243,
      ' 2-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


