set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7703389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '1',
      '2',
      '0',
      '4',
      '1',
      '2',
      '4',
      '0',
      '2',
      NULL,
      NULL,
      '1',
      '2',
      '2',
      '0',
      '0',
      '1',
      '3',
      '2',
      '2',
      '0',
      NULL,
      '',
      '4',
      NULL,
      '3',
      '1',
      '3',
      NULL,
      '1',
      NULL,
      '',
      '0',
      '3',
      '3',
      '4',
      '0',
      '3',
      '3',
      '3',
      '2',
      '3',
      NULL,
      '140',
      '42240144',
      69.416970,
      NULL,
      '2422402',
      2.468178,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-11-1992',
      95.764036,
      169.713625,
      NULL,
      12.453294,
      26,
      16.144963,
      NULL,
      11,
      23.444451,
      7,
      13.078102,
      10.539366,
      4,
      NULL,
      23,
      18.409513,
      24,
      22.324469,
      61,
      NULL,
      11.760439,
      14.131024,
      35,
      11,
      1,
      12,
      13,
      7.399278,
      204,
      NULL,
      109.307831,
      ' 6-24-1977',
      20,
      49.405029,
      13,
      31,
      11.660622,
      29,
      ' 0-18-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      21.947033,
      NULL,
      25,
      5,
      '10-20-1991',
      1.777353,
      0.877892,
      NULL,
      1,
      1,
      1,
      NULL,
      1.801680,
      67,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1975',
      47,
      74,
      2,
      24.815450,
      17.428940,
      NULL,
      87.791671,
      NULL,
      54,
      80,
      69.953059,
      26,
      ' 4-28-1994',
      NULL,
      19,
      2.488589,
      29.725846,
      44,
      156,
      8,
      NULL,
      3,
      2,
      ' 5-12-1984',
      7,
      4.850554,
      0,
      10,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      4,
      1,
      0,
      '10-21-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      0,
      ' 4-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1994',
      NULL,
      ' 6- 8-1978',
      5.877749,
      8,
      ' 4-20-1996',
      58.528727,
      105.109015,
      ' 4- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      26,
      NULL,
      43.152190,
      16,
      23,
      '10- 3-2003',
      NULL,
      152,
      ' 1-13-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


