set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128421';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330',
      '33002114',
      '30132333',
      '23423321',
      '14102140',
      '24244400',
      '33233440',
      '10301442',
      NULL,
      NULL,
      '21113221',
      '12202232',
      NULL,
      '41212421',
      '42311313',
      NULL,
      '31124440',
      '20141231',
      NULL,
      '00411212',
      '43112234',
      '33021210',
      '32324234',
      NULL,
      NULL,
      NULL,
      '23143044',
      '42201210',
      '40331233',
      '42011432',
      '13132302',
      NULL,
      '40234300',
      NULL,
      '24034041',
      '42333424',
      '21412110',
      '23111422',
      '21420200',
      '22024322',
      '01101310',
      '04412431',
      '41113413',
      NULL,
      '03013304',
      '224',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      '030134',
      4,
      ' 5-19-1988',
      ' 6- 1-1986',
      68,
      NULL,
      23.437976,
      16,
      9,
      7,
      29.042998,
      12.126007,
      27.611778,
      17,
      19,
      7.044818,
      38.364097,
      NULL,
      25,
      10,
      NULL,
      18.292326,
      NULL,
      0,
      8,
      21,
      85.667426,
      9.185510,
      NULL,
      123.570393,
      118,
      14,
      201.228222,
      141.611613,
      NULL,
      ' 7-27-1979',
      58,
      33.851983,
      26,
      1.090696,
      144,
      111,
      ' 8- 1-1977',
      NULL,
      1.080267,
      NULL,
      1,
      0,
      1.736628,
      1.503075,
      1.364540,
      1.771562,
      NULL,
      0.102026,
      0,
      NULL,
      1.407016,
      0,
      1.522259,
      NULL,
      1.886677,
      1.342007,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.157693,
      30,
      NULL,
      28,
      NULL,
      2.335016,
      ' 6-29-1978',
      NULL,
      1,
      102.029002,
      1.722425,
      1.600426,
      6,
      0,
      0.909942,
      8,
      0,
      0,
      115,
      ' 7-12-1997',
      NULL,
      70,
      63,
      14.854622,
      58,
      NULL,
      73.637866,
      7.006321,
      7.868548,
      72.717547,
      60,
      55.565962,
      ' 3-19-1982',
      13,
      7,
      21,
      2,
      51,
      107.616778,
      7,
      '11-24-1991',
      16,
      7.773937,
      ' 4-27-1978',
      10.329152,
      8,
      19,
      NULL,
      10,
      NULL,
      0,
      8.550146,
      NULL,
      71.140062,
      7.704223,
      11.098652,
      NULL,
      31,
      1.307243,
      0.709071,
      0,
      1,
      ' 2-25-1998',
      NULL,
      2.094881,
      3,
      ' 6-21-1997',
      54.098427,
      44.194248,
      ' 4- 7-1994',
      NULL,
      1.068315,
      '10-21-1981',
      13,
      ' 1-20-1986',
      43.823643,
      ' 8-17-1979',
      11,
      6,
      '11-13-1976',
      NULL,
      37,
      ' 6-12-1983',
      4,
      1,
      ' 1- 9-2003',
      NULL,
      1.253775,
      ' 9-23-1997',
      2,
      2,
      19,
      ' 7- 2-2003',
      45,
      15.966814,
      30.760875,
      ' 6- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


