set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1423',
      '33322111',
      '01223433',
      '11041220',
      '01403331',
      '13441040',
      '12114414',
      '14412234',
      '32043033',
      '10420102',
      '31222240',
      '13343103',
      '00230334',
      NULL,
      '00341423',
      '30201401',
      '44121232',
      '00440404',
      '23023301',
      NULL,
      '14330031',
      '13401431',
      '01042123',
      '13440243',
      '40402141',
      '21134011',
      '10321302',
      '34444001',
      '33112221',
      '33313341',
      '33214030',
      '11120343',
      '42420424',
      '40344224',
      '02320334',
      '40401244',
      NULL,
      '34144442',
      '10444410',
      '30331111',
      '30102443',
      NULL,
      '40012322',
      NULL,
      '24203023',
      '',
      '',
      NULL,
      NULL,
      '4410432',
      1,
      0.735998,
      1,
      NULL,
      '310203',
      2,
      '11- 5-2001',
      ' 6-27-1976',
      58.345791,
      NULL,
      35,
      17.240441,
      NULL,
      4.980793,
      22,
      NULL,
      36,
      NULL,
      19.405753,
      11.271308,
      19,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.870292,
      NULL,
      8,
      NULL,
      11.321978,
      NULL,
      NULL,
      NULL,
      100.153079,
      50,
      195,
      NULL,
      ' 9-23-1989',
      60.453363,
      24.971880,
      21.122388,
      39.559500,
      NULL,
      14.978281,
      '10- 4-1977',
      NULL,
      1,
      0,
      0.780338,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.174084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-11-1990',
      112,
      90,
      94,
      100,
      61,
      30,
      40,
      17.524258,
      106,
      58.750353,
      67,
      124,
      ' 7-29-1984',
      6,
      NULL,
      20,
      39.022388,
      NULL,
      62.145788,
      3,
      NULL,
      18.373090,
      26,
      NULL,
      0.701017,
      NULL,
      23,
      0,
      5.587114,
      7.784515,
      NULL,
      4.997466,
      NULL,
      78,
      0.846255,
      4.338941,
      19.335519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      9,
      48.231541,
      ' 9- 6-1995',
      1.592382,
      24.912055,
      NULL,
      6.767343,
      3.143020,
      13.702039,
      6.773094,
      ' 0-22-1985',
      2,
      0.783979,
      27,
      ' 2- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      14.888055,
      0,
      NULL,
      NULL,
      15,
      5.436532,
      0,
      3.738612,
      1,
      NULL,
      NULL,
      0,
      1,
      9.116457,
      1,
      3,
      54.558572,
      0.667132,
      3.740929,
      87,
      NULL,
      4,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.219869,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      16.156171,
      NULL,
      NULL,
      NULL,
      0,
      11.257106,
      0.678502,
      1.452566,
      NULL,
      47,
      NULL,
      NULL,
      1,
      NULL,
      1.102285,
      1.658589,
      NULL,
      32,
      3,
      28.072908,
      NULL,
      NULL,
      23,
      NULL,
      13,
      0,
      1.696592,
      5.131856,
      1.669188,
      1.675748,
      1,
      1,
      NULL,
      '11-24-1975',
      '10- 0-1980',
      ' 8- 9-1993',
      ' 3-18-2000',
      '11-23-2001',
      ' 0-24-1988',
      NULL,
      NULL);
commit;
end;
/


