set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1343',
      '32242042',
      '02304402',
      '14112412',
      NULL,
      '24331103',
      '44204321',
      '12434423',
      NULL,
      '21003231',
      '40032034',
      '00010342',
      '30210003',
      NULL,
      '31320124',
      '22021102',
      '04443300',
      '23214412',
      NULL,
      '02224200',
      '04132443',
      '30432430',
      NULL,
      '12330010',
      '01231402',
      '04230042',
      '31102242',
      '02340004',
      NULL,
      '13212133',
      '03422440',
      '23000124',
      NULL,
      '31403330',
      '21010241',
      '41031331',
      NULL,
      NULL,
      '43313322',
      '30232432',
      '10331314',
      '31303042',
      NULL,
      '02123342',
      NULL,
      '023',
      NULL,
      31,
      5,
      NULL,
      0,
      0.766769,
      0,
      NULL,
      '110121',
      3.141900,
      ' 2-11-1981',
      ' 4- 8-1988',
      73.641478,
      44,
      11.370893,
      4,
      25,
      NULL,
      53.352258,
      5.163940,
      NULL,
      1,
      12,
      8,
      32.290295,
      16,
      22,
      9.319325,
      7.541950,
      3,
      NULL,
      1,
      0,
      12,
      56,
      4,
      1.928023,
      30,
      137,
      31.563974,
      33.136432,
      42,
      106.979872,
      NULL,
      2.835969,
      20.948991,
      25,
      19,
      100.890203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      67,
      NULL,
      16.434723,
      NULL,
      NULL,
      91.616820,
      NULL,
      NULL,
      92.759408,
      23,
      71.950536,
      ' 4- 2-2000',
      10,
      1,
      NULL,
      34,
      37.442364,
      9,
      5,
      ' 6-20-1994',
      13.380552,
      NULL,
      '10-14-1979',
      2.312377,
      7.355494,
      6.812166,
      5.719237,
      7.080556,
      NULL,
      1.033155,
      3,
      NULL,
      8.255452,
      3.890924,
      0.859132,
      0,
      15.125094,
      0.022924,
      3.788196,
      0.238031,
      0.600279,
      ' 5- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      92.346487,
      6,
      ' 9-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-22-1981',
      6.425498,
      ' 7-22-1999',
      10.194621,
      13.470122,
      ' 2- 5-2001',
      114.471336,
      NULL,
      '10-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15,
      NULL,
      NULL,
      5.911947,
      14,
      ' 8-12-1991',
      4.303011,
      331.939609,
      '11-26-1987',
      7,
      23.549642,
      7.347383,
      81,
      NULL,
      37.219172,
      1,
      323,
      ' 9-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


