set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7618530';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30310444',
      '32031044',
      NULL,
      '13041302',
      '42330001',
      '30022234',
      '32120041',
      '22424410',
      '22430320',
      NULL,
      '34314114',
      '20104340',
      '44134121',
      '33440241',
      '10000333',
      NULL,
      '03110130',
      NULL,
      '11420400',
      '20224042',
      NULL,
      '11431412',
      '33133022',
      '01120144',
      NULL,
      NULL,
      '23341411',
      '10204330',
      '20302232',
      '34140142',
      '43011334',
      '21043430',
      '02333241',
      '13301423',
      '02031042',
      '12300330',
      '40223423',
      '04433311',
      '32213431',
      '10114140',
      NULL,
      '32040414',
      NULL,
      '44120240',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.817694,
      1.278996,
      2,
      NULL,
      '120220',
      0,
      ' 9-13-1990',
      ' 8-17-1974',
      59,
      NULL,
      26,
      11,
      23,
      5.643094,
      29.401407,
      13,
      5,
      3,
      14,
      9.785984,
      23,
      10,
      NULL,
      2,
      NULL,
      9.374379,
      13.149138,
      4,
      NULL,
      8,
      7,
      2.432017,
      NULL,
      12.034755,
      107,
      NULL,
      NULL,
      90.325504,
      151,
      '11- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.124551,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.049858,
      30.333254,
      69,
      NULL,
      3.096913,
      56.714174,
      NULL,
      56,
      3,
      1,
      2,
      34.347115,
      NULL,
      6.267378,
      NULL,
      14,
      18,
      22,
      5,
      3,
      ' 6-21-1985',
      13,
      3,
      ' 3-24-1978',
      4,
      3,
      8.376928,
      3,
      13.515539,
      11,
      NULL,
      4,
      NULL,
      7,
      NULL,
      NULL,
      7.588507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      20.259967,
      13.031677,
      ' 3-21-1998',
      1,
      324.987525,
      ' 6- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      63.328661,
      NULL,
      NULL,
      20.673282,
      105,
      NULL,
      NULL,
      11.891940,
      3.850759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.761772,
      6,
      NULL,
      5.927839,
      4.796526,
      3,
      1,
      1,
      NULL,
      ' 2-26-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-24-1981',
      NULL);
commit;
end;
/


