set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12414232',
      '00234004',
      NULL,
      '21402444',
      '21443040',
      '14343212',
      '23444114',
      NULL,
      NULL,
      '03031421',
      '42003242',
      '34142010',
      NULL,
      '14030014',
      '44443423',
      '12340100',
      '22242413',
      '30132402',
      '20402240',
      '41214041',
      '34203134',
      '31120431',
      '20131221',
      NULL,
      '22004422',
      '42010004',
      '34441043',
      '22301210',
      '42340441',
      NULL,
      '23104111',
      '31434340',
      '13130224',
      '21041014',
      '31221124',
      '11112323',
      '01401323',
      '04313434',
      '31131123',
      '34420124',
      '22120032',
      '14112040',
      '40202041',
      '11134321',
      '330',
      '44',
      41.852596,
      9,
      '2331401',
      NULL,
      1,
      2,
      NULL,
      '133014',
      5,
      ' 4- 2-1977',
      ' 3-24-1993',
      115.704753,
      248.585964,
      26,
      19,
      5,
      21,
      50,
      5.019946,
      NULL,
      9,
      28,
      5,
      33.460069,
      3.910546,
      NULL,
      8,
      13.124938,
      15.555333,
      3.924776,
      NULL,
      22,
      22,
      93,
      2,
      NULL,
      84.652388,
      NULL,
      NULL,
      102,
      32.946212,
      108,
      ' 8-21-1997',
      38.436400,
      37,
      NULL,
      33.822154,
      NULL,
      132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      16,
      12,
      2,
      ' 8-13-1992',
      1,
      1.926322,
      67.827660,
      NULL,
      0.061607,
      0,
      2.400828,
      3,
      73.235160,
      NULL,
      NULL,
      NULL,
      '11-17-1994',
      91.216296,
      128,
      32.543464,
      99.825697,
      9,
      24.241194,
      85,
      36.722278,
      129,
      68.393888,
      NULL,
      103,
      ' 1-18-1978',
      1,
      NULL,
      12.607425,
      58,
      45.870718,
      21.320917,
      11,
      ' 8- 9-1979',
      9,
      1,
      '11-17-1984',
      15,
      NULL,
      4,
      6,
      NULL,
      3.545462,
      1.196165,
      19.723395,
      1.920228,
      21.165945,
      3.094425,
      0.280721,
      19.938434,
      24.628813,
      1.784979,
      1.960617,
      2.763404,
      NULL,
      ' 8- 2-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      157.271660,
      4,
      ' 6-10-2001',
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      21.444865,
      NULL,
      8,
      12.977938,
      NULL,
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      12,
      ' 4- 7-1980',
      69.653475,
      47,
      5,
      '11- 5-1993',
      2.687986,
      NULL,
      ' 9-28-1996',
      16,
      52.110712,
      14,
      53,
      ' 5-14-2003',
      35.946576,
      1,
      132.790880,
      ' 1-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


