set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '4',
      '1',
      '1',
      '4',
      '2',
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      '4',
      '3',
      '0',
      '3',
      '0',
      '3',
      '2',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '',
      '1',
      '',
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      '4',
      '0',
      '2',
      '2',
      '3',
      '0',
      '0',
      '1',
      '003',
      '43200002',
      NULL,
      53.399273,
      '0013022',
      0.582123,
      0,
      3,
      0,
      NULL,
      4,
      ' 9- 5-2001',
      ' 3-16-2002',
      9.860685,
      67,
      32.320493,
      17.560966,
      20,
      4,
      NULL,
      1.449195,
      11,
      3.334983,
      17.192844,
      0.559772,
      0.421547,
      NULL,
      10.137851,
      12,
      15.811842,
      NULL,
      58,
      10,
      7,
      NULL,
      47,
      8,
      0,
      69.597733,
      90.272651,
      7.518123,
      178.170170,
      93,
      11.066318,
      ' 1-20-1982',
      55,
      25,
      13.135878,
      22,
      NULL,
      185.881580,
      ' 7- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.307409,
      NULL,
      5.474579,
      23,
      0,
      '10-17-2000',
      1.540909,
      0,
      142.063784,
      0,
      1.690608,
      NULL,
      1,
      NULL,
      71.266262,
      NULL,
      NULL,
      NULL,
      '11-20-1980',
      86.157932,
      NULL,
      NULL,
      33.146687,
      45.740929,
      NULL,
      NULL,
      NULL,
      63.400788,
      31,
      1.904560,
      39,
      NULL,
      4.217659,
      5,
      9,
      53,
      NULL,
      26,
      NULL,
      ' 8-27-2001',
      NULL,
      3.138106,
      '10-15-1983',
      NULL,
      1.420620,
      5.017692,
      13.817219,
      12.099235,
      4,
      0,
      3.946372,
      0.893878,
      10,
      6,
      1,
      0.995390,
      17,
      3.346370,
      4.955514,
      0,
      0,
      ' 7- 4-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-2002',
      28,
      ' 0-24-1977',
      2,
      15,
      ' 5- 6-1989',
      30.628814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      ' 0- 3-1994',
      21.102745,
      29,
      4,
      ' 8-16-2002',
      0,
      4,
      ' 7-25-1974',
      6,
      74,
      15.942852,
      31,
      ' 8-29-2003',
      NULL,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


