set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9751858';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '2',
      '3',
      '3',
      '2',
      '0',
      '4',
      NULL,
      '1',
      '2',
      '4',
      '3',
      '1',
      '2',
      '0',
      NULL,
      '3',
      '2',
      '0',
      '3',
      '2',
      '0',
      '2',
      '',
      '1',
      NULL,
      '3',
      '3',
      '4',
      '4',
      NULL,
      '',
      '',
      '1',
      '1',
      '3',
      '0',
      NULL,
      '0',
      '0',
      '1',
      '4',
      '3',
      '3',
      '042',
      '10301320',
      2,
      19.576230,
      '0341140',
      3,
      1.688266,
      NULL,
      NULL,
      '203341',
      2.192841,
      ' 5-24-1997',
      ' 2-19-1989',
      NULL,
      19.498200,
      31,
      14.775805,
      1,
      6,
      50,
      14.331275,
      10,
      3.217728,
      43.285317,
      7.986951,
      19,
      23,
      NULL,
      12,
      29,
      NULL,
      47,
      5,
      NULL,
      15,
      96,
      NULL,
      1,
      109,
      6.165415,
      27.776429,
      218,
      180.071533,
      170,
      ' 8- 9-1977',
      22.162781,
      0,
      22.852627,
      32,
      164,
      148.126766,
      ' 8-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      4.621231,
      7,
      10,
      1.732866,
      NULL,
      1,
      0.061364,
      147,
      NULL,
      0.421900,
      NULL,
      1.765921,
      5,
      64.911001,
      NULL,
      NULL,
      NULL,
      ' 6-18-1987',
      59,
      79,
      101.756321,
      84,
      67.325459,
      61.452302,
      78.613187,
      56.787062,
      NULL,
      NULL,
      63.419814,
      15.653554,
      ' 8-26-1983',
      5,
      27,
      10.090169,
      9.528738,
      NULL,
      79.518613,
      3,
      ' 9- 6-1982',
      NULL,
      21,
      ' 8-24-1982',
      NULL,
      2,
      12,
      9.006150,
      7,
      1,
      1,
      11.478396,
      0,
      26,
      3,
      7,
      0.972106,
      3,
      3.864301,
      1.276282,
      0,
      0,
      ' 0- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      143.126516,
      3.170932,
      ' 6-12-1993',
      NULL,
      NULL,
      NULL,
      55.955157,
      NULL,
      23,
      ' 3-22-1974',
      16,
      0.667670,
      ' 2-21-1980',
      93,
      116,
      ' 6- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.638850,
      '11-17-1996',
      NULL,
      33,
      21,
      NULL,
      0,
      67.448937,
      ' 3- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


