set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912491';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0031',
      '10002201',
      '04231120',
      '42310041',
      '00030102',
      NULL,
      NULL,
      '34122000',
      '00000040',
      '02124143',
      '01122214',
      '40301433',
      NULL,
      NULL,
      '42201313',
      NULL,
      NULL,
      '14032002',
      '33120300',
      '12120404',
      NULL,
      '12412411',
      '04140430',
      '40242101',
      '33323014',
      '30430304',
      '30040103',
      '23423311',
      '01412023',
      '01142031',
      '34404444',
      '12120002',
      NULL,
      '43122333',
      '22402413',
      '03410022',
      '33033103',
      '02230123',
      '40004220',
      '33413322',
      '23204220',
      '40124031',
      '34204402',
      '21404022',
      '30313141',
      '',
      '',
      NULL,
      NULL,
      '0311303',
      2,
      1.654678,
      3,
      NULL,
      NULL,
      0,
      '10-26-1994',
      '11-14-1980',
      30.930283,
      NULL,
      35.104037,
      12.475236,
      28.426330,
      7.558154,
      102,
      NULL,
      38.267015,
      16.454270,
      19.124101,
      10.907994,
      NULL,
      4,
      12.611646,
      NULL,
      25.835221,
      22.599795,
      8.344269,
      2.872578,
      62.052685,
      9.021877,
      136,
      8,
      NULL,
      174.272739,
      NULL,
      26.305328,
      34,
      209.097620,
      22,
      ' 3-24-1978',
      36,
      NULL,
      NULL,
      38.283234,
      60,
      30.371912,
      ' 0-15-1983',
      0,
      0.489136,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.674673,
      0.585338,
      0.839042,
      NULL,
      0.454678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-11-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-13-1980',
      NULL,
      128.497243,
      126.026701,
      42.661751,
      18,
      15,
      23.112348,
      75.165145,
      NULL,
      36,
      64.909691,
      27,
      ' 6- 2-1987',
      24,
      15,
      NULL,
      5,
      90.838979,
      NULL,
      2,
      '10-23-1995',
      15.704578,
      37.428466,
      ' 8-13-1994',
      6,
      NULL,
      20,
      NULL,
      0.363134,
      11.943237,
      NULL,
      28.581619,
      NULL,
      60,
      1.643033,
      1,
      19.425423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      10,
      NULL,
      NULL,
      NULL,
      68.357597,
      ' 3-28-1992',
      16.005432,
      8,
      21.283495,
      10.634019,
      ' 0- 1-1994',
      13,
      1,
      NULL,
      ' 7-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.404276,
      NULL,
      NULL,
      16,
      30,
      4,
      9,
      19,
      0,
      NULL,
      NULL,
      0,
      16,
      1,
      0.322202,
      22,
      NULL,
      3,
      21.790841,
      0.755481,
      1,
      1,
      NULL,
      2.510334,
      NULL,
      0.546109,
      NULL,
      1,
      1,
      0.046729,
      NULL,
      1,
      0.447434,
      NULL,
      NULL,
      NULL,
      7.776401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669970,
      NULL,
      0,
      3,
      NULL,
      26,
      6.223481,
      1,
      NULL,
      NULL,
      1.591023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-1985',
      ' 7-17-1999',
      ' 2- 5-1985',
      NULL,
      ' 6- 8-1980',
      ' 8- 5-2003',
      NULL,
      NULL);
commit;
end;
/


