set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '4',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '0',
      '2',
      '3',
      '0',
      '4',
      '2',
      '4',
      '4',
      '4',
      '1',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '4',
      '',
      '4',
      '1',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '1',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      '21120100',
      NULL,
      31,
      NULL,
      0.988810,
      NULL,
      NULL,
      NULL,
      '122411',
      0.225232,
      '11-10-1978',
      '10-21-1976',
      110,
      85,
      NULL,
      1.831243,
      17,
      13.106644,
      NULL,
      8.064636,
      8.817195,
      NULL,
      14.736550,
      2,
      19,
      11,
      15.167354,
      5,
      7.340912,
      6,
      31.842359,
      7.838370,
      NULL,
      10.555279,
      17,
      8,
      1.517859,
      8.026131,
      NULL,
      18.448790,
      68.840075,
      136,
      NULL,
      ' 8-13-2001',
      NULL,
      12.524739,
      2.194369,
      NULL,
      78,
      124,
      ' 2-27-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.257838,
      NULL,
      6,
      15.829129,
      14.778235,
      2,
      NULL,
      NULL,
      1.582104,
      NULL,
      NULL,
      2.106671,
      54.990731,
      1,
      2.444381,
      37,
      NULL,
      NULL,
      NULL,
      ' 1-27-1984',
      29,
      NULL,
      38,
      45,
      30,
      7.747097,
      13.869579,
      12,
      10,
      22.142027,
      NULL,
      8,
      ' 8-10-1979',
      25.151818,
      37,
      NULL,
      36.443283,
      NULL,
      57.276273,
      9.379869,
      NULL,
      1,
      17.002175,
      NULL,
      9,
      10,
      4.628027,
      12,
      13,
      3,
      4,
      11.855623,
      0,
      65,
      3.639936,
      NULL,
      11.014080,
      5.237489,
      7.805397,
      1,
      0.376608,
      1,
      ' 5-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      ' 1-27-1999',
      NULL,
      NULL,
      NULL,
      28,
      ' 7-22-1976',
      18,
      ' 1-28-1996',
      9,
      11.420642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 9-21-1995',
      26.667072,
      9.474719,
      3.407142,
      ' 7- 3-1998',
      3.568490,
      NULL,
      ' 9-28-1994',
      5,
      97.993333,
      8,
      58.017666,
      NULL,
      34,
      1.927367,
      114,
      '10- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


