set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '0',
      '0',
      '4',
      '2',
      '4',
      '2',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '3',
      '3',
      '2',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '3',
      '2',
      '3',
      '',
      '4',
      '',
      '0',
      '2',
      '1',
      '3',
      '3',
      '',
      '',
      '3',
      '2',
      '2',
      NULL,
      '0',
      '3',
      '1',
      '3',
      '0',
      '3',
      '0',
      '012',
      NULL,
      36,
      24,
      '4133034',
      1,
      NULL,
      1,
      1,
      '022310',
      4,
      '11-15-1983',
      '11- 0-2001',
      8,
      86.195285,
      9.791517,
      1,
      20,
      10,
      49,
      13.569658,
      NULL,
      8,
      20,
      7.792396,
      13.930200,
      17.682670,
      2.754792,
      5.850144,
      NULL,
      7,
      6.806748,
      8,
      0,
      2.729614,
      NULL,
      14,
      NULL,
      36,
      159.645974,
      56.084216,
      27,
      28,
      86.293419,
      ' 5-15-1996',
      25,
      NULL,
      1.113293,
      NULL,
      67,
      151.907731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      NULL,
      10.570385,
      13.449935,
      NULL,
      ' 8-10-1997',
      0.660748,
      NULL,
      56.944228,
      0.084708,
      0,
      101,
      0.587119,
      0,
      28.056168,
      NULL,
      NULL,
      NULL,
      '10-15-2000',
      NULL,
      NULL,
      26,
      38.346600,
      28.477087,
      9,
      16.546649,
      27,
      22,
      47.783992,
      21.080633,
      30.291626,
      ' 4-29-2000',
      45,
      15,
      NULL,
      66.263030,
      79,
      6.810242,
      8.350367,
      ' 7-11-1983',
      2.564047,
      11.409875,
      ' 7-17-2001',
      5,
      0,
      11.896672,
      13,
      NULL,
      1,
      0,
      11,
      NULL,
      NULL,
      2.671438,
      NULL,
      0.342261,
      NULL,
      3.986378,
      NULL,
      1.042342,
      1.232915,
      '10-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      ' 3-20-1979',
      18,
      '10- 4-1995',
      10.047639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      9.494573,
      ' 1-10-1995',
      15.545205,
      27.468207,
      8,
      NULL,
      0,
      15.249043,
      ' 3-14-1985',
      NULL,
      97,
      NULL,
      20.087257,
      ' 7-11-1989',
      24.112659,
      1.591222,
      81,
      ' 8-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


