set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4221',
      '13344230',
      '10313224',
      NULL,
      '34203124',
      '00002140',
      '11210001',
      '02144322',
      '32222140',
      '21412321',
      '21333111',
      '30101210',
      '02101234',
      '03244033',
      '22033243',
      '44101210',
      '31401241',
      '23031213',
      '32303341',
      NULL,
      '04134422',
      '21001010',
      '20042114',
      '12032302',
      '22102000',
      '04302424',
      '14343322',
      '04103424',
      NULL,
      '14304204',
      '00243123',
      '40220402',
      '44232112',
      '40002314',
      NULL,
      '23212433',
      '13204400',
      '30244444',
      '01012323',
      NULL,
      NULL,
      '23400241',
      '21100210',
      '01432141',
      '10320000',
      '240',
      '23',
      NULL,
      NULL,
      NULL,
      0.240991,
      NULL,
      NULL,
      NULL,
      '420143',
      0.892174,
      NULL,
      ' 5- 7-1975',
      105.191687,
      NULL,
      NULL,
      15.742661,
      NULL,
      12,
      NULL,
      7.921168,
      7,
      NULL,
      24,
      NULL,
      NULL,
      1.140654,
      NULL,
      NULL,
      24,
      0.466330,
      13,
      1.021096,
      NULL,
      10,
      58.521930,
      6,
      0,
      36.137164,
      78,
      46,
      129,
      37.330699,
      NULL,
      ' 3-22-1975',
      19.507072,
      NULL,
      26,
      NULL,
      59.820739,
      135,
      ' 3- 7-1978',
      2,
      2.934202,
      2.630527,
      1.299810,
      8.605130,
      NULL,
      4.776470,
      0,
      0,
      1,
      NULL,
      1.096976,
      NULL,
      2.820673,
      NULL,
      1.952751,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1985',
      42,
      20.803186,
      NULL,
      26.134830,
      NULL,
      3.211276,
      ' 3- 0-1992',
      0.215001,
      6.481671,
      128,
      0.704701,
      0,
      41,
      0,
      1.737887,
      25.979444,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1997',
      13,
      NULL,
      64.536526,
      77,
      98,
      0,
      NULL,
      36,
      80,
      2,
      NULL,
      0,
      ' 6-23-1985',
      7.968816,
      15.892223,
      18.234930,
      45,
      54,
      NULL,
      6,
      ' 8- 6-1985',
      21,
      16,
      ' 9- 6-1989',
      NULL,
      6.110313,
      NULL,
      3,
      8,
      NULL,
      0,
      18.086763,
      1,
      70,
      2.268390,
      NULL,
      0.089530,
      NULL,
      1.818911,
      9,
      4.505296,
      0,
      '11-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      21.677550,
      22,
      ' 2- 4-1992',
      NULL,
      NULL,
      NULL,
      15,
      ' 9-16-1994',
      17,
      ' 0-29-1999',
      13.198537,
      6.873746,
      '10-21-1993',
      NULL,
      NULL,
      NULL,
      4,
      1,
      ' 4-17-1977',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15.012256,
      ' 4-29-1987',
      11.880368,
      19.665734,
      5.079573,
      ' 2- 8-1987',
      0,
      229,
      NULL,
      NULL,
      156,
      5,
      12,
      ' 0-19-1998',
      41.281700,
      NULL,
      317,
      ' 3-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


