set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      '1',
      '0',
      NULL,
      '4',
      '4',
      '0',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '3',
      '0',
      '1',
      '2',
      '1',
      '1',
      '1',
      NULL,
      '4',
      NULL,
      '',
      '0',
      '',
      '4',
      '4',
      '4',
      '0',
      '2',
      NULL,
      '',
      '3',
      '1',
      '1',
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '0',
      '0',
      '4',
      '440',
      '20022310',
      67,
      47,
      NULL,
      1.383030,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      ' 1- 0-1990',
      72,
      26,
      33,
      13,
      NULL,
      6,
      61,
      13,
      6,
      3.825987,
      2,
      4,
      NULL,
      6,
      22.770565,
      17.125987,
      NULL,
      12,
      16.773048,
      NULL,
      35,
      10,
      40,
      14.911897,
      0.786128,
      51.627330,
      2.561540,
      12.611630,
      39.815543,
      48.319944,
      NULL,
      ' 4-28-2000',
      14.130311,
      22,
      4.559993,
      23,
      116.030618,
      88,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      8.469498,
      16.890470,
      5.945038,
      ' 5-18-1976',
      1.143870,
      NULL,
      144.981744,
      NULL,
      1,
      29.892136,
      0.971078,
      0.561584,
      71.405460,
      NULL,
      NULL,
      NULL,
      NULL,
      90.401669,
      27,
      63,
      71.915699,
      16,
      NULL,
      NULL,
      NULL,
      26,
      60.221882,
      54.246969,
      80,
      ' 2-18-1990',
      13.060947,
      NULL,
      4,
      29.693378,
      NULL,
      13,
      8,
      ' 9- 8-1998',
      0.234135,
      1,
      ' 3-11-1989',
      6,
      5.597500,
      5,
      9.028317,
      NULL,
      2,
      NULL,
      6,
      0,
      NULL,
      0,
      1.008205,
      0.191188,
      24,
      5,
      3,
      0,
      1.808216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.610924,
      0.881803,
      ' 9- 3-1975',
      NULL,
      NULL,
      NULL,
      24.971490,
      ' 4-16-1986',
      29,
      ' 1-23-1994',
      2.093817,
      0.977495,
      ' 0- 1-1979',
      82.285292,
      21.213719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      17.197235,
      19.323406,
      3,
      '10- 4-1978',
      1,
      186,
      ' 7-24-1999',
      0,
      NULL,
      23,
      15.657649,
      ' 8- 1-1988',
      22.706371,
      0,
      NULL,
      ' 8-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


