set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '4',
      '3',
      NULL,
      '2',
      '3',
      '3',
      '2',
      NULL,
      '4',
      '1',
      '1',
      '3',
      '0',
      '4',
      '0',
      '2',
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '',
      '1',
      NULL,
      '0',
      '1',
      NULL,
      '4',
      '0',
      '',
      '',
      '0',
      NULL,
      '3',
      NULL,
      '2',
      '4',
      '4',
      '1',
      '2',
      '4',
      '2',
      NULL,
      '33031240',
      51,
      65.828345,
      NULL,
      0.716321,
      14,
      1,
      0,
      NULL,
      1,
      NULL,
      ' 2- 1-1981',
      88,
      302.004268,
      NULL,
      11,
      NULL,
      9,
      49,
      NULL,
      18.604853,
      23,
      18,
      12.056075,
      NULL,
      8.163834,
      12,
      NULL,
      13,
      9.089251,
      8.623737,
      3.379834,
      3.172718,
      11,
      NULL,
      NULL,
      1,
      7,
      21,
      31,
      14.864357,
      75,
      120,
      ' 1- 2-1998',
      41.912185,
      55.786811,
      14.839913,
      9.316196,
      123.201314,
      87,
      '10- 1-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.999923,
      9,
      6.392369,
      5,
      NULL,
      0.161246,
      2,
      NULL,
      1.926297,
      0,
      133,
      NULL,
      0.641027,
      53.342101,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      54.303756,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      16,
      29,
      22.026087,
      NULL,
      ' 6- 1-1998',
      29,
      4,
      NULL,
      69,
      54,
      NULL,
      NULL,
      ' 6- 1-1980',
      19,
      13,
      NULL,
      18.457471,
      10,
      16.131388,
      30,
      20,
      1.452855,
      1.725022,
      7,
      0.728880,
      19,
      3.317142,
      1.584079,
      12.768132,
      NULL,
      1.517483,
      0,
      1.152921,
      0.315328,
      ' 3-13-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-15-1982',
      NULL,
      NULL,
      NULL,
      29.708664,
      ' 3-10-1981',
      17.114429,
      NULL,
      11,
      9.478737,
      ' 0-19-2003',
      42.176852,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 5- 5-2003',
      41,
      20,
      NULL,
      ' 5-19-1976',
      NULL,
      44,
      '10-13-1978',
      7,
      NULL,
      14,
      37.118712,
      ' 4-16-1999',
      9,
      0.348154,
      12.012687,
      ' 5-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


