set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4203',
      '30110122',
      '44413140',
      '11211241',
      '40100141',
      '31402403',
      '23214342',
      '04203041',
      '32122130',
      NULL,
      NULL,
      '32220141',
      NULL,
      '42202103',
      '11441422',
      '23132202',
      '01430104',
      NULL,
      NULL,
      '22041422',
      '20144120',
      '40402440',
      '41310030',
      NULL,
      '21032303',
      '03421024',
      '40412311',
      NULL,
      '23004121',
      NULL,
      '33231032',
      '03441033',
      NULL,
      NULL,
      NULL,
      '20211031',
      NULL,
      '22421241',
      '33004024',
      '21312340',
      '01400340',
      '01014422',
      '21130114',
      '23434341',
      '34120434',
      '002',
      '10',
      NULL,
      NULL,
      '2131423',
      NULL,
      1.981191,
      1,
      NULL,
      '310102',
      5,
      '11-15-1979',
      '11-25-1992',
      NULL,
      NULL,
      49.778513,
      5.568264,
      18,
      NULL,
      60.666652,
      NULL,
      NULL,
      5.984993,
      34,
      10,
      16,
      11.315606,
      18,
      20.021509,
      30,
      14.520747,
      71.319133,
      28,
      48,
      0.147196,
      48.581062,
      NULL,
      1,
      84,
      NULL,
      6.636477,
      106.491178,
      227.986816,
      NULL,
      ' 4-13-1991',
      6.930803,
      58.466184,
      24,
      15,
      NULL,
      NULL,
      ' 8-14-1981',
      NULL,
      1.292079,
      NULL,
      NULL,
      5,
      0.615328,
      2,
      0.744974,
      1.886969,
      0.368497,
      1,
      1.400718,
      0,
      0.849065,
      1.321908,
      0.935877,
      NULL,
      NULL,
      1.180532,
      2.507854,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-24-1985',
      82,
      20.730281,
      0.587985,
      6.827646,
      1,
      NULL,
      ' 2-29-1983',
      0,
      1.266069,
      169.247503,
      NULL,
      1,
      131.544254,
      0.194373,
      3.134748,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      88.040785,
      NULL,
      35.694370,
      98,
      26.768490,
      NULL,
      75.183844,
      33.792898,
      NULL,
      21.118222,
      ' 0-15-2000',
      24,
      16.065781,
      NULL,
      67,
      16.371986,
      76.498454,
      5.999072,
      '11- 6-1983',
      1.098076,
      21.454219,
      ' 6-27-1992',
      12.451588,
      7.116167,
      0,
      24.226273,
      4,
      8.734488,
      0.083798,
      23.277330,
      0.342374,
      68,
      1,
      5,
      NULL,
      9,
      1,
      1,
      1.060959,
      1,
      ' 3-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      0,
      ' 1-21-2001',
      8.687572,
      9,
      '11-25-1975',
      119,
      3.180369,
      NULL,
      NULL,
      3.204076,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.173806,
      ' 9-27-1993',
      59,
      NULL,
      44,
      ' 8- 9-2001',
      1,
      46,
      ' 6-27-1989',
      2,
      32.229783,
      14.062440,
      28,
      '11-15-1974',
      60,
      0,
      NULL,
      ' 5-24-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


