set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2002',
      '42224030',
      '31311113',
      NULL,
      NULL,
      '22131133',
      '01221002',
      NULL,
      '43001420',
      NULL,
      '22443444',
      '01002020',
      NULL,
      NULL,
      '23033244',
      '11011034',
      '32032444',
      '43141340',
      '22011132',
      '00312342',
      NULL,
      '42324301',
      '32233023',
      '20032410',
      NULL,
      NULL,
      '12442413',
      NULL,
      '14341022',
      NULL,
      '11421011',
      '44312204',
      '21013320',
      '01021403',
      '30222421',
      '21213004',
      '22203313',
      '04440342',
      '10133201',
      '12112220',
      '13224411',
      '41220101',
      '03000101',
      NULL,
      '24433432',
      NULL,
      NULL,
      NULL,
      NULL,
      '3123312',
      2,
      26,
      NULL,
      NULL,
      '340132',
      0,
      ' 0- 6-1983',
      NULL,
      125,
      75,
      26,
      12.186606,
      1,
      17,
      NULL,
      17.234753,
      6,
      13,
      NULL,
      1.463528,
      14.636149,
      NULL,
      16.717828,
      14,
      1,
      9,
      76,
      3.244138,
      36,
      NULL,
      92.825981,
      9,
      1,
      47,
      162,
      NULL,
      36.061847,
      27.551523,
      166,
      ' 5- 0-1996',
      8.498087,
      29.474379,
      NULL,
      37.003197,
      181,
      NULL,
      ' 0-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.568520,
      46,
      NULL,
      NULL,
      NULL,
      0.124377,
      NULL,
      0,
      2.957433,
      NULL,
      NULL,
      1.609452,
      124,
      5,
      1,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      27.579575,
      104,
      91,
      88,
      93,
      NULL,
      109.937229,
      4,
      18.267128,
      36,
      NULL,
      ' 9-18-1996',
      8,
      6,
      25,
      14,
      42,
      NULL,
      10.430043,
      NULL,
      5,
      NULL,
      ' 6-19-1996',
      NULL,
      6.383094,
      NULL,
      19,
      24,
      0,
      1.788225,
      11,
      0.021653,
      114,
      NULL,
      NULL,
      1.238867,
      25.041525,
      3,
      0.300126,
      1.572653,
      1.832784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.854047,
      ' 7- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 8-1987',
      41.098886,
      NULL,
      7.488269,
      18,
      ' 5-23-1980',
      4.657736,
      30.471518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 1- 4-1983',
      50.138801,
      24.969755,
      28.629932,
      ' 6-18-1999',
      NULL,
      33.175104,
      NULL,
      NULL,
      25.088847,
      NULL,
      15.191061,
      ' 4-13-1991',
      NULL,
      0,
      54.936602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


