set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001945';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '03104012',
      '11143030',
      '00404333',
      '14230343',
      '31204021',
      NULL,
      '13223314',
      '31212311',
      '13322132',
      '30413223',
      '13202030',
      '03001012',
      '01231221',
      '34040322',
      '13141121',
      '11043340',
      NULL,
      '14033023',
      '24200431',
      '21002212',
      '41002032',
      '23123200',
      '01203122',
      '40422322',
      '33123431',
      '02434100',
      '23144341',
      '22224031',
      NULL,
      '02030140',
      '21004314',
      '30000000',
      '01002440',
      '13043323',
      '02202423',
      '11440031',
      '22241420',
      '34432043',
      NULL,
      '24113124',
      NULL,
      '22134132',
      '04214110',
      '24230202',
      '',
      '',
      NULL,
      NULL,
      '4441434',
      0,
      1,
      2,
      NULL,
      NULL,
      3,
      ' 6-21-1982',
      '11-19-1998',
      5,
      NULL,
      16,
      13.563308,
      26,
      11.197405,
      20,
      1.720866,
      10,
      16.526272,
      22.781201,
      5,
      NULL,
      6,
      NULL,
      6,
      NULL,
      5,
      NULL,
      9,
      8,
      4.916951,
      62.467915,
      7.881566,
      NULL,
      76.714243,
      34,
      63.748668,
      17.147674,
      30,
      15,
      ' 7- 1-2001',
      1,
      28,
      25,
      0.155310,
      133,
      173.080684,
      ' 6-18-1985',
      NULL,
      6.577994,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526632,
      NULL,
      1,
      1.083333,
      3.085955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1978',
      106,
      50.958864,
      26.787941,
      70.009376,
      0.578274,
      NULL,
      NULL,
      21.470331,
      70.438357,
      29.589321,
      9.409482,
      80.679537,
      ' 6- 3-1980',
      8,
      23.072069,
      14.945098,
      7,
      38,
      110,
      8,
      ' 0-15-1997',
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.148486,
      NULL,
      2.007395,
      NULL,
      7,
      NULL,
      41.189234,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.475390,
      NULL,
      14.609145,
      ' 7-25-1993',
      1,
      169.411661,
      ' 7-10-1998',
      5.175594,
      44,
      NULL,
      21.585351,
      ' 8-11-1987',
      49.432440,
      NULL,
      NULL,
      '10-20-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      79.003746,
      NULL,
      NULL,
      NULL,
      46.819167,
      13.419813,
      25,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.350303,
      NULL,
      30.722238,
      NULL,
      0.929325,
      110.401307,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      1.323325,
      NULL,
      0.251746,
      NULL,
      2,
      0.629490,
      1.788264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991291,
      1,
      11.433077,
      0.628315,
      1.625064,
      NULL,
      NULL,
      0.232779,
      NULL,
      1.493654,
      NULL,
      1.870401,
      2,
      NULL,
      NULL,
      1,
      22.320614,
      NULL,
      NULL,
      NULL,
      NULL,
      8.346927,
      5.869783,
      1.309072,
      NULL,
      1.685835,
      0,
      0.894178,
      1,
      NULL,
      '11-18-1992',
      NULL,
      NULL,
      ' 4-13-1996',
      ' 8-12-1986',
      ' 9-23-2003',
      ' 8-18-1980',
      NULL);
commit;
end;
/


