set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4342',
      NULL,
      '21002142',
      '04402213',
      '43423210',
      '01124241',
      '22422431',
      NULL,
      '42333212',
      '32003123',
      '44310141',
      '44304204',
      '40403302',
      '44331411',
      '00212324',
      '42342022',
      '40224432',
      '42103011',
      NULL,
      NULL,
      NULL,
      '14103400',
      '42032121',
      '33012033',
      '00133430',
      NULL,
      '02322433',
      '00111023',
      '32001040',
      '43434444',
      '13404214',
      '13413400',
      '11040340',
      '42334333',
      '31332334',
      NULL,
      '20204302',
      '04233340',
      NULL,
      '03404243',
      '12123104',
      '34434204',
      '44222200',
      '32414414',
      '41231334',
      '112',
      '00',
      NULL,
      NULL,
      '0231412',
      1,
      0.516432,
      0,
      NULL,
      '323031',
      1.766815,
      NULL,
      NULL,
      75.016826,
      NULL,
      50.719618,
      NULL,
      13,
      12.269614,
      17,
      4,
      22.256496,
      NULL,
      3.769415,
      12,
      14,
      12,
      20,
      16.090030,
      8.051385,
      NULL,
      45.964001,
      25,
      52.523365,
      8.726332,
      25.743021,
      18.364902,
      1,
      NULL,
      213,
      102.579321,
      NULL,
      NULL,
      200,
      ' 5- 2-1999',
      19,
      22,
      27,
      NULL,
      130,
      90,
      ' 6-29-2000',
      0.095118,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.809205,
      0.229134,
      0,
      1,
      1.642235,
      1,
      3.756798,
      1,
      1.836290,
      1.205394,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      2.066747,
      6.488067,
      12,
      12,
      9.545252,
      '11-13-2003',
      NULL,
      1.442284,
      138,
      0,
      1.707450,
      19.483753,
      NULL,
      0,
      89,
      NULL,
      0,
      184.578908,
      ' 9- 3-1998',
      64.383939,
      21.392214,
      3.442685,
      29,
      43.764944,
      101.306863,
      62,
      9.495723,
      97.082246,
      35.463189,
      NULL,
      65,
      ' 1-22-1999',
      25.400153,
      NULL,
      13.999619,
      30,
      8,
      38.951619,
      7,
      NULL,
      15,
      24.095171,
      ' 6-26-1995',
      NULL,
      NULL,
      26,
      23,
      14.566782,
      12,
      0.580156,
      NULL,
      NULL,
      105.270311,
      1,
      1,
      0.476098,
      NULL,
      1.205335,
      1.686899,
      0,
      1.825594,
      ' 0-28-1988',
      0.272364,
      NULL,
      NULL,
      ' 1-26-1990',
      101.465651,
      2,
      '10- 7-1978',
      68.162675,
      2,
      '11-22-1993',
      34.376046,
      ' 8- 5-1993',
      38.617044,
      ' 8- 6-1994',
      4,
      19.289312,
      ' 5- 6-1987',
      68,
      117.006668,
      ' 6-18-1990',
      2.003032,
      13,
      NULL,
      0.466720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10-21-2001',
      22.945366,
      NULL,
      29,
      ' 1-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.226579);
commit;
end;
/


