set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9831665';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '0',
      '1',
      '3',
      '3',
      '4',
      '2',
      '0',
      '1',
      '2',
      NULL,
      '4',
      '2',
      '3',
      '4',
      NULL,
      '2',
      '0',
      '1',
      '0',
      NULL,
      '',
      '4',
      '',
      '0',
      '1',
      '4',
      '2',
      '2',
      '',
      '',
      '4',
      '0',
      '2',
      '3',
      '4',
      NULL,
      '0',
      '4',
      '0',
      '3',
      '1',
      NULL,
      '23204042',
      17.233664,
      14,
      '4022010',
      0,
      1,
      2,
      NULL,
      NULL,
      3,
      ' 8- 9-1979',
      ' 9-21-1996',
      40,
      73.173726,
      NULL,
      0.256833,
      22.912868,
      7,
      60,
      6.834791,
      4.486655,
      0.911064,
      18,
      NULL,
      12,
      2,
      NULL,
      11,
      13.207977,
      7.298843,
      25.484403,
      NULL,
      3,
      8,
      NULL,
      3.506045,
      0,
      86.523776,
      157,
      66,
      164,
      139.984583,
      37.653617,
      ' 2-19-1977',
      14.653078,
      35,
      31,
      9,
      NULL,
      145,
      ' 9-21-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.398712,
      40,
      NULL,
      15.917672,
      NULL,
      2,
      NULL,
      0,
      NULL,
      73,
      0.998772,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1987',
      49,
      NULL,
      NULL,
      45.971519,
      4.035357,
      106.781313,
      110.003958,
      NULL,
      47,
      84.213421,
      76,
      49,
      ' 2- 5-1999',
      16.927807,
      4,
      5,
      NULL,
      38.050003,
      39,
      3,
      ' 5- 4-1988',
      3,
      8.107777,
      '10-17-1983',
      10,
      NULL,
      3,
      14.132716,
      16,
      0,
      0.084527,
      0,
      NULL,
      97,
      NULL,
      1,
      3.785264,
      11.408647,
      NULL,
      3,
      NULL,
      1.131004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.537739,
      NULL,
      ' 7-14-1988',
      NULL,
      NULL,
      NULL,
      2.031904,
      ' 7-13-1978',
      NULL,
      ' 6- 7-1977',
      8,
      9.465002,
      ' 5-22-1998',
      73,
      94.010621,
      ' 0- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 7-13-1976',
      5.049998,
      40,
      NULL,
      ' 5-14-1998',
      1.851058,
      26,
      ' 3- 6-1977',
      NULL,
      15,
      13,
      NULL,
      '10-23-1997',
      54.405092,
      0,
      38,
      ' 8- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


