set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      '1',
      NULL,
      '2',
      '2',
      '1',
      '3',
      '2',
      '2',
      NULL,
      '0',
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '4',
      '',
      '0',
      '2',
      '0',
      NULL,
      '3',
      '',
      '',
      '2',
      NULL,
      '1',
      NULL,
      '2',
      '4',
      '0',
      '2',
      '4',
      '3',
      '3',
      '311',
      '13222000',
      15,
      80.435466,
      '0234202',
      1.474087,
      NULL,
      0,
      0,
      '123114',
      4.258847,
      ' 6-24-1998',
      NULL,
      177.286190,
      NULL,
      18,
      1.882272,
      NULL,
      12.267994,
      10.419937,
      11.902225,
      4,
      5.298541,
      7,
      2,
      17,
      11.976343,
      2.073890,
      NULL,
      20.631102,
      19,
      4,
      NULL,
      NULL,
      3.880026,
      27,
      13,
      1,
      51,
      14.265081,
      NULL,
      128,
      12,
      111,
      NULL,
      32.999127,
      48.136315,
      34.099829,
      11,
      54.580229,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      14,
      0,
      11.064119,
      3.730750,
      NULL,
      ' 3- 8-1979',
      0.568800,
      0,
      34.386356,
      3,
      1.378054,
      NULL,
      0,
      NULL,
      63,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1980',
      NULL,
      53,
      74,
      49,
      NULL,
      38.219480,
      94,
      40,
      97.202840,
      87,
      64.605288,
      NULL,
      ' 1-19-1995',
      NULL,
      11.270920,
      NULL,
      24,
      NULL,
      25.944440,
      0.075354,
      ' 4- 2-1989',
      7.509497,
      1,
      ' 4-21-1988',
      8.736148,
      NULL,
      8,
      17,
      1,
      8.368341,
      0,
      7.185560,
      0.445230,
      NULL,
      NULL,
      0,
      9.271040,
      15,
      3.638438,
      0,
      0.524424,
      NULL,
      ' 7- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      5.473889,
      ' 6-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.933582,
      ' 7-23-1981',
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.046899,
      ' 6- 2-1988',
      1,
      3.510389,
      19.364196,
      ' 9- 1-1981',
      1,
      68,
      NULL,
      1.078365,
      NULL,
      NULL,
      8,
      '11- 9-1989',
      57,
      3,
      NULL,
      '10-10-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


