set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '3',
      '1',
      '0',
      '1',
      NULL,
      '1',
      '2',
      '4',
      '4',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2',
      '1',
      '3',
      NULL,
      '3',
      '2',
      '1',
      '',
      '3',
      '',
      '0',
      NULL,
      '4',
      '4',
      '2',
      '',
      '',
      '0',
      '1',
      NULL,
      '0',
      '2',
      '0',
      '0',
      '1',
      '2',
      '2',
      '1',
      NULL,
      '4',
      23.957570,
      81.865548,
      '0400003',
      NULL,
      12,
      0,
      0,
      '000404',
      NULL,
      ' 6-17-1999',
      ' 9- 7-1978',
      91,
      209.315308,
      4.057474,
      NULL,
      10.374149,
      NULL,
      NULL,
      10,
      2.234105,
      8.917522,
      29,
      14,
      NULL,
      NULL,
      12,
      0.454267,
      NULL,
      5,
      49.023911,
      19.137569,
      33,
      0,
      61.020595,
      10.221481,
      1,
      75.269667,
      22,
      37,
      45,
      NULL,
      153.552861,
      ' 6- 2-1984',
      30,
      NULL,
      14.952378,
      4,
      55.724688,
      204.748354,
      '11- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      2,
      9,
      2,
      7.559198,
      2,
      NULL,
      0.996765,
      NULL,
      17.220506,
      0,
      0.119328,
      103,
      0.450377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1997',
      2.100830,
      74,
      95,
      66,
      53,
      NULL,
      57.003713,
      NULL,
      NULL,
      20.761800,
      23,
      NULL,
      ' 1-22-1997',
      NULL,
      11,
      13,
      10,
      40.501650,
      0,
      9.798141,
      NULL,
      23.970142,
      28.028945,
      ' 0-22-1982',
      4.439604,
      0,
      NULL,
      9.613159,
      6,
      1.439645,
      1,
      5,
      NULL,
      62,
      1,
      1,
      13,
      NULL,
      NULL,
      7.692635,
      NULL,
      1,
      ' 4- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      128,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      ' 1-14-1974',
      20,
      ' 2- 2-1977',
      7.002252,
      NULL,
      ' 6- 1-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      13.323781,
      ' 0- 5-1984',
      NULL,
      NULL,
      20.768622,
      '10-26-1999',
      0.219739,
      93,
      ' 8- 9-1989',
      2.021654,
      19.229250,
      9,
      22.520349,
      NULL,
      64,
      0,
      NULL,
      ' 5-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


