set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3323',
      '32001000',
      '30101410',
      '24403443',
      '44320443',
      '33142120',
      NULL,
      '44021422',
      '02014414',
      NULL,
      '00020302',
      '14420001',
      NULL,
      NULL,
      '24044411',
      '32413212',
      '31413230',
      '23003431',
      '10123343',
      '12033130',
      '00033011',
      '23324113',
      '44010310',
      NULL,
      NULL,
      '43440321',
      '30411000',
      NULL,
      '41343013',
      NULL,
      '40014002',
      '12301131',
      '22111302',
      '10412023',
      NULL,
      NULL,
      '14020132',
      '24203130',
      '22002410',
      NULL,
      '13223244',
      '33220240',
      '41031340',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2143441',
      3,
      NULL,
      1,
      NULL,
      '322210',
      0,
      ' 9-24-1985',
      ' 6-23-1998',
      67.780152,
      NULL,
      15,
      15,
      4.375360,
      7,
      32,
      6,
      3,
      9.040865,
      NULL,
      NULL,
      35.828607,
      3,
      13,
      9,
      9.326074,
      1.369834,
      43.439891,
      15.330578,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      46,
      29.821152,
      NULL,
      87.646333,
      NULL,
      ' 2-29-1979',
      NULL,
      0.558544,
      9.058371,
      NULL,
      98.823949,
      93.898555,
      ' 8- 6-1976',
      4.896273,
      4,
      0.988114,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451671,
      NULL,
      0,
      0,
      6.540451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1983',
      71.633150,
      6,
      41,
      17,
      84.085168,
      88.330371,
      76,
      46,
      77.557465,
      66,
      85,
      2,
      ' 1-17-1977',
      0,
      NULL,
      NULL,
      18,
      54,
      NULL,
      6.251011,
      ' 8-27-1974',
      NULL,
      NULL,
      ' 8-11-1996',
      NULL,
      7.368145,
      NULL,
      NULL,
      16,
      1,
      NULL,
      13.623272,
      NULL,
      25.187506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.764639,
      2.707341,
      15,
      '10- 8-1983',
      0,
      135,
      NULL,
      0.155863,
      21.768082,
      2,
      39.310329,
      '10-21-2001',
      41,
      1.515064,
      7.131364,
      ' 8-23-1984',
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      40,
      NULL,
      5,
      NULL,
      26.644450,
      5,
      NULL,
      28.131247,
      6.249739,
      16.506389,
      0.642698,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0.509600,
      0.375451,
      19,
      4,
      1,
      248.059158,
      NULL,
      6,
      113.031492,
      0,
      20,
      1.273058,
      0,
      1,
      0,
      0,
      NULL,
      132.950990,
      55.308162,
      14.486617,
      21,
      NULL,
      36,
      NULL,
      NULL,
      7.323137,
      1.077812,
      NULL,
      0,
      4,
      1,
      42.773033,
      5,
      56.754735,
      1.626035,
      1,
      64,
      32,
      NULL,
      17.583159,
      7,
      NULL,
      17,
      NULL,
      8.809879,
      13,
      3,
      6.155031,
      0,
      0.968907,
      1.352054,
      1.616990,
      76,
      '10-20-1978',
      ' 4-12-1986',
      ' 7- 3-2000',
      ' 8- 1-1992',
      ' 3- 8-1991',
      ' 3-14-1985',
      '10- 9-1987',
      NULL);
commit;
end;
/


