set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7527326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      '11144300',
      '13134220',
      NULL,
      '44203134',
      NULL,
      '22430330',
      '23323431',
      '21324113',
      '44304410',
      '22203401',
      '02023034',
      '04424142',
      '31120423',
      NULL,
      NULL,
      '23134141',
      NULL,
      '14404303',
      NULL,
      '23002342',
      '04323043',
      '23034422',
      '22002132',
      '01440243',
      NULL,
      '01310411',
      '22114224',
      '24001221',
      '12440300',
      '23124300',
      '21244214',
      '10243234',
      '42241222',
      '13043214',
      NULL,
      '44224240',
      NULL,
      NULL,
      '03041111',
      '21331332',
      '44401213',
      '41404122',
      '00212113',
      '24002144',
      NULL,
      '34',
      40,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '411112',
      NULL,
      '11-15-1984',
      NULL,
      8.793060,
      54,
      6,
      7.104147,
      12.693208,
      11,
      56,
      NULL,
      7,
      6,
      NULL,
      16.839931,
      36.512976,
      28,
      3.002082,
      NULL,
      15,
      NULL,
      NULL,
      2,
      NULL,
      9,
      38,
      15,
      0,
      52,
      119,
      68,
      91,
      215.916069,
      235.042820,
      ' 0-28-1983',
      39.836670,
      NULL,
      25,
      20.999418,
      202.045950,
      210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75.647828,
      9.192129,
      1.167010,
      3,
      NULL,
      NULL,
      ' 4- 7-1987',
      0,
      0.838844,
      168.579504,
      NULL,
      NULL,
      125,
      0,
      0.372836,
      79.258511,
      NULL,
      NULL,
      NULL,
      ' 0-23-1996',
      72.184160,
      NULL,
      NULL,
      11.079847,
      NULL,
      NULL,
      26,
      84.481753,
      53.070064,
      91.596253,
      NULL,
      61,
      NULL,
      28.612965,
      10,
      4,
      23.005362,
      NULL,
      44.082258,
      5.448698,
      ' 9-27-1986',
      31.322006,
      16,
      '11-21-1989',
      2,
      23,
      2.937918,
      NULL,
      31.454155,
      6.503641,
      NULL,
      NULL,
      0.739376,
      61.156324,
      0,
      1,
      NULL,
      10.623598,
      1,
      0.118915,
      NULL,
      1,
      ' 0- 9-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      ' 1-16-1986',
      NULL,
      NULL,
      NULL,
      59.874781,
      ' 3- 2-1997',
      NULL,
      ' 0-28-1983',
      0,
      4,
      NULL,
      36,
      18.834629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12,
      ' 7-20-1977',
      12,
      2,
      NULL,
      ' 1-20-1976',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


