set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888356';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '3',
      '4',
      '3',
      '4',
      '0',
      '2',
      '0',
      '3',
      NULL,
      '3',
      NULL,
      '4',
      '1',
      '4',
      '2',
      '',
      '0',
      '',
      '0',
      NULL,
      '4',
      NULL,
      NULL,
      '',
      '',
      '1',
      NULL,
      NULL,
      '2',
      '0',
      '1',
      '4',
      '4',
      '0',
      '4',
      '2',
      '303',
      '14330114',
      78.514718,
      50.460450,
      '4104132',
      NULL,
      1,
      2,
      0,
      '122010',
      5.194240,
      NULL,
      '11- 5-1982',
      7.835695,
      77,
      0,
      29,
      2.091100,
      23.685537,
      4.097186,
      NULL,
      5,
      14,
      29.502386,
      NULL,
      NULL,
      11.731215,
      3,
      13,
      23.532788,
      NULL,
      79,
      18.366046,
      NULL,
      15,
      57.275240,
      5,
      0.347778,
      6.209445,
      123.501056,
      11.447433,
      114,
      90,
      238.256193,
      ' 2- 5-1996',
      31,
      NULL,
      26.720381,
      38,
      104,
      179,
      ' 6-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.960710,
      7,
      NULL,
      4.059675,
      8.893134,
      '10- 4-1999',
      0.420899,
      1.428573,
      151,
      NULL,
      1,
      118.729171,
      1.933689,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1981',
      34.528137,
      118.240049,
      NULL,
      93.042876,
      10.657437,
      NULL,
      79.026116,
      29,
      79,
      25.604849,
      101.782789,
      NULL,
      ' 4-14-1983',
      23,
      9.735899,
      11,
      30,
      46.579911,
      177,
      8,
      ' 9- 2-2000',
      NULL,
      22.503147,
      '10- 2-1987',
      13.927206,
      NULL,
      9,
      0.958021,
      3,
      NULL,
      0,
      22.487283,
      NULL,
      137,
      3,
      NULL,
      22,
      17.365381,
      NULL,
      0,
      NULL,
      1.097337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      171.569430,
      4,
      ' 2- 5-1982',
      NULL,
      NULL,
      NULL,
      19.876356,
      ' 5-18-1974',
      37,
      ' 4-29-2003',
      11.387317,
      11,
      ' 2- 7-1989',
      177,
      77.250410,
      ' 0-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1992',
      NULL,
      0,
      NULL,
      '10-24-1987',
      0,
      18,
      '10- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


