set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9720207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '1',
      '1',
      '3',
      '3',
      '3',
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '4',
      '0',
      '0',
      '4',
      '2',
      NULL,
      '2',
      '0',
      '4',
      '1',
      '',
      NULL,
      NULL,
      '2',
      NULL,
      '4',
      '2',
      '0',
      '',
      '',
      '0',
      '3',
      '3',
      '2',
      '0',
      '4',
      '0',
      '2',
      '2',
      '2',
      '2',
      '103',
      '24002431',
      NULL,
      47.868738,
      '1104103',
      1,
      0,
      0,
      NULL,
      '103224',
      3,
      ' 3-22-2002',
      '11-25-1990',
      11.480454,
      83.280362,
      NULL,
      NULL,
      9,
      13.848278,
      97.935955,
      10,
      28,
      13,
      13,
      17.556766,
      29,
      6.101594,
      0,
      NULL,
      7,
      13,
      57.010177,
      8,
      26,
      5.169451,
      NULL,
      4.152408,
      0.223043,
      56.756781,
      178,
      12,
      216.417624,
      108,
      52,
      ' 3-21-1992',
      50.951826,
      36.781717,
      9,
      17.701391,
      189,
      49,
      ' 6-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      3,
      4,
      7.028164,
      5.040931,
      ' 2-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.449986,
      108,
      50,
      41.623461,
      NULL,
      68.904858,
      23,
      97,
      NULL,
      29,
      NULL,
      40,
      ' 2-11-1995',
      NULL,
      25.280961,
      6.359167,
      73,
      38.256846,
      13.989698,
      6,
      ' 2- 2-1995',
      NULL,
      9,
      ' 0-25-1974',
      10.290143,
      12,
      23.150712,
      20.270993,
      22,
      11.165460,
      1,
      8,
      0.954293,
      26,
      0.571976,
      4.679338,
      NULL,
      16.552585,
      1.973836,
      1,
      0,
      0.286204,
      ' 0-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6-20-1974',
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      15,
      ' 9- 0-1991',
      10.909460,
      13.504870,
      NULL,
      63,
      43,
      ' 5-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9,
      ' 6- 0-1978',
      NULL,
      22.784926,
      NULL,
      ' 4-15-1993',
      NULL,
      105.310263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


