set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3412',
      '34033444',
      '11413131',
      '02434241',
      '21431204',
      '00020340',
      '40043201',
      '01330302',
      '42030041',
      '04240010',
      NULL,
      '21000211',
      '41242412',
      '02140114',
      '00323141',
      '02311022',
      '20233004',
      '03120434',
      '33003311',
      NULL,
      '11443433',
      '43220303',
      '34043412',
      '10300014',
      '00022042',
      '01122432',
      '20213233',
      '42214123',
      NULL,
      NULL,
      '10210021',
      '11444210',
      '10324220',
      NULL,
      '00441313',
      '42234442',
      NULL,
      '13412440',
      '20044232',
      NULL,
      '24232013',
      '20031410',
      NULL,
      '31112204',
      '42410100',
      '',
      '',
      NULL,
      NULL,
      '3043331',
      0,
      0.658652,
      NULL,
      NULL,
      NULL,
      2.533703,
      ' 5- 8-1974',
      NULL,
      NULL,
      NULL,
      23.010328,
      NULL,
      NULL,
      3.320882,
      NULL,
      6,
      NULL,
      NULL,
      18,
      3,
      36.762853,
      14,
      27.686530,
      15,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.911517,
      NULL,
      NULL,
      111,
      55.108530,
      72.934725,
      75.133591,
      NULL,
      ' 5-11-1984',
      18.571514,
      4,
      14,
      NULL,
      35.245859,
      130,
      ' 2-12-1983',
      6,
      1,
      4.329786,
      1.135088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193451,
      1.778708,
      0.979691,
      0.208016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      13,
      NULL,
      83,
      72,
      26,
      6,
      ' 4-17-1989',
      NULL,
      NULL,
      '11-17-1996',
      4,
      7,
      5,
      20.358858,
      24.588743,
      NULL,
      NULL,
      21,
      NULL,
      52.679118,
      1,
      3.154107,
      13.409866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      4.318768,
      '10- 6-1988',
      NULL,
      3,
      8.733222,
      18.776442,
      ' 7-23-1979',
      22.162897,
      1.601030,
      187,
      ' 9-13-1987',
      NULL,
      NULL,
      NULL,
      24,
      0,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      21.056426,
      1.671809,
      NULL,
      0,
      1,
      44.058651,
      2.812051,
      NULL,
      74.333271,
      1.031392,
      2.029939,
      51,
      NULL,
      NULL,
      NULL,
      7,
      6.696279,
      13.700881,
      1.552743,
      17.254562,
      0.944763,
      NULL,
      0.543856,
      1,
      1.961563,
      NULL,
      22.342149,
      NULL,
      20,
      17.638225,
      NULL,
      30,
      7,
      NULL,
      23.272120,
      0.356690,
      2.579115,
      1.250877,
      NULL,
      1.257204,
      NULL,
      0.935307,
      45.321986,
      2,
      1.037420,
      27,
      17.118280,
      14.950544,
      26,
      37,
      12.246769,
      NULL,
      NULL,
      7.006618,
      3.430456,
      NULL,
      0,
      1.670231,
      0,
      1,
      0.456768,
      NULL,
      ' 1- 8-2003',
      NULL,
      ' 3-25-1974',
      '10-11-1977',
      ' 1-20-1992',
      NULL,
      ' 9-22-1978',
      NULL);
commit;
end;
/


