set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8424170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1021',
      '24121202',
      '03423223',
      '40444024',
      '32323310',
      '01434043',
      '13133224',
      '14213034',
      '11233313',
      NULL,
      '43411411',
      '34130040',
      '22430244',
      NULL,
      '30223140',
      NULL,
      '00432444',
      '14110134',
      '43434030',
      '32042230',
      '03230312',
      '22124331',
      '44423240',
      NULL,
      '23012102',
      '20131022',
      '41303302',
      '23414034',
      '21404014',
      '44114301',
      NULL,
      '11101113',
      '03130131',
      NULL,
      '24442102',
      NULL,
      '44101340',
      '33001034',
      '34003214',
      '33434044',
      '01304441',
      '40400322',
      '44200311',
      '12421144',
      '04221231',
      NULL,
      '40',
      NULL,
      NULL,
      '0230032',
      2.537210,
      6,
      0,
      NULL,
      NULL,
      3.330215,
      ' 6-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      3,
      2,
      16,
      NULL,
      8,
      8,
      25,
      NULL,
      28.047524,
      22.169084,
      9,
      NULL,
      9,
      14,
      20.069904,
      6.019039,
      NULL,
      8.899601,
      24,
      11.889828,
      1.621151,
      58,
      NULL,
      61.135465,
      82,
      189,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280942,
      6,
      45.139041,
      69,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.354255,
      NULL,
      0,
      1.073529,
      ' 5-23-1976',
      1.905716,
      NULL,
      118.738892,
      0.394754,
      1.944587,
      NULL,
      NULL,
      2.199829,
      12.968271,
      0.046212,
      1,
      42,
      NULL,
      103,
      69.160980,
      NULL,
      NULL,
      40.524005,
      92,
      84,
      68,
      51,
      79.584381,
      69.757663,
      6.572228,
      ' 2- 5-2000',
      6,
      26,
      30.882583,
      16.670963,
      120.272683,
      139,
      8.935096,
      ' 3-14-1985',
      24.793025,
      4.514698,
      NULL,
      NULL,
      13.095907,
      19.383181,
      NULL,
      NULL,
      4,
      1.116646,
      9.213197,
      1,
      NULL,
      0,
      2.289222,
      11.918399,
      23.272882,
      0,
      1.550626,
      NULL,
      1,
      '10-14-1977',
      4,
      1.720814,
      1.655861,
      '11-24-1998',
      177,
      12.751619,
      '11-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1974',
      18,
      NULL,
      8,
      13.230154,
      NULL,
      NULL,
      40.175138,
      ' 9-10-1983',
      5,
      0,
      ' 4-12-1992',
      1,
      NULL,
      ' 4-22-1977',
      1,
      2,
      2,
      ' 1-29-1979',
      22.786641,
      20.723814,
      17,
      ' 0- 9-1986',
      2.665535,
      13.386244,
      ' 0-11-1979',
      7,
      3.673926,
      0.969647,
      85.096236,
      ' 5-14-1992',
      NULL,
      0.362079,
      NULL,
      ' 8- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


