set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '4',
      '3',
      NULL,
      '1',
      '2',
      '1',
      '3',
      '4',
      '3',
      '1',
      '2',
      NULL,
      '0',
      NULL,
      '3',
      '1',
      '4',
      '1',
      NULL,
      '3',
      '2',
      '4',
      '',
      '0',
      '',
      '3',
      '4',
      '0',
      '1',
      '2',
      '',
      '',
      '1',
      NULL,
      '0',
      '0',
      '1',
      '2',
      '0',
      '2',
      '1',
      '2',
      NULL,
      NULL,
      '24403103',
      88,
      NULL,
      '0133144',
      0.457920,
      101,
      NULL,
      1,
      '314204',
      0,
      ' 7- 0-1979',
      '10- 6-1978',
      32,
      190.389813,
      4.627996,
      8,
      12,
      4,
      NULL,
      8.750204,
      9,
      10.200372,
      18.939750,
      5,
      27.166190,
      0.323560,
      12.489955,
      NULL,
      23.732733,
      21,
      27,
      18,
      64.493353,
      12,
      NULL,
      1,
      1.008373,
      43,
      134,
      28.982525,
      183,
      143.215104,
      58,
      '11- 6-1996',
      31.934842,
      NULL,
      15,
      21.381031,
      163.701014,
      131,
      ' 9-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      20,
      NULL,
      9,
      NULL,
      6.450848,
      ' 6- 6-1987',
      1,
      7,
      73,
      6.907628,
      0.390205,
      19.217228,
      1.852654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1998',
      99,
      69.586959,
      10,
      8.429057,
      2.405613,
      34,
      NULL,
      NULL,
      NULL,
      19,
      34,
      NULL,
      ' 3-27-1980',
      7.155080,
      4,
      2.262118,
      11,
      NULL,
      9.131399,
      3.962685,
      ' 0-14-1982',
      NULL,
      9.336170,
      ' 7-26-1982',
      NULL,
      NULL,
      0,
      7,
      17.157119,
      7,
      2.186915,
      15,
      1,
      50.075457,
      11.760426,
      0,
      6.146296,
      NULL,
      NULL,
      6.843824,
      0,
      1,
      ' 7-21-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      119.097510,
      36,
      ' 0- 1-1977',
      NULL,
      NULL,
      NULL,
      24.499295,
      '11-18-1993',
      19.889161,
      ' 2-10-1985',
      NULL,
      0,
      ' 4-23-1978',
      NULL,
      83,
      ' 0-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.386254,
      ' 4-27-1986',
      40.830030,
      30.469741,
      NULL,
      NULL,
      0,
      96,
      ' 4-13-1974',
      5,
      NULL,
      6.896249,
      33,
      ' 0-23-1990',
      67.334701,
      0,
      28.676642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


