set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7125247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2023',
      '22420411',
      '11442244',
      '34220114',
      '20434114',
      '04031434',
      '03223412',
      '10020402',
      '14320434',
      '04411030',
      '14441013',
      '14031302',
      '40444011',
      '22312204',
      NULL,
      '43400131',
      '10030100',
      '24104424',
      '41421223',
      '11240103',
      '02423113',
      '24044324',
      '22223000',
      NULL,
      '00034020',
      NULL,
      NULL,
      '40222034',
      '23004204',
      '42444022',
      '02412234',
      '34321340',
      '43400100',
      '33102031',
      '01131114',
      NULL,
      '22032332',
      '44033144',
      NULL,
      '10102240',
      '03001234',
      NULL,
      '43402331',
      '30234122',
      '10043201',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0.938243,
      NULL,
      NULL,
      NULL,
      '120342',
      2.917835,
      '10- 6-1999',
      NULL,
      NULL,
      NULL,
      32.191538,
      1,
      9.846901,
      5.000927,
      120,
      NULL,
      5,
      19,
      3,
      13,
      43.330271,
      13.129108,
      3,
      NULL,
      17,
      10,
      33,
      NULL,
      5,
      16,
      112,
      NULL,
      NULL,
      83.197679,
      177.471154,
      46.112296,
      138.504679,
      NULL,
      114,
      ' 4-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372083,
      2,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916981,
      0,
      0.535636,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1982',
      103.418945,
      80.032363,
      150,
      110,
      24,
      128.538350,
      71,
      135.710568,
      84,
      127,
      NULL,
      4,
      ' 8- 4-1994',
      17,
      15,
      13.108578,
      75,
      61,
      NULL,
      3.461593,
      ' 4-29-1989',
      NULL,
      NULL,
      NULL,
      1.435329,
      3,
      19,
      4,
      14.014115,
      5,
      NULL,
      NULL,
      NULL,
      134,
      1.103705,
      8,
      3.885625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.790404,
      4,
      NULL,
      ' 0-10-1983',
      0,
      50,
      ' 6- 3-1995',
      15.540160,
      10.439808,
      22.662283,
      10.515492,
      ' 8- 5-1990',
      8.816769,
      0,
      NULL,
      '11- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      61.669200,
      51.512439,
      41,
      72,
      3.388153,
      14.487049,
      2,
      13.093486,
      5.235065,
      6,
      NULL,
      0.766816,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397835,
      NULL,
      4,
      0.474606,
      0,
      58,
      73.121365,
      23,
      33,
      0.199312,
      57,
      NULL,
      0.021364,
      0,
      0,
      1.776383,
      0.042275,
      66,
      51.733123,
      NULL,
      NULL,
      22.050865,
      8,
      1,
      0.515617,
      35,
      1.070596,
      0.484845,
      2,
      9,
      1,
      NULL,
      1.304382,
      22.541788,
      0.749664,
      1.371610,
      60.355264,
      24.047009,
      13,
      2,
      87,
      39,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      2,
      1,
      0,
      0.866741,
      0.391980,
      90,
      ' 2- 7-1999',
      ' 3-23-1991',
      ' 7-29-1986',
      ' 8- 4-1976',
      ' 9-20-2000',
      NULL,
      ' 3- 7-2003',
      NULL);
commit;
end;
/


