set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10142212',
      '44003012',
      '24123300',
      '43143141',
      NULL,
      '11342214',
      '14200004',
      '33312104',
      '32123411',
      '12240303',
      '41313230',
      '12424141',
      '00403342',
      NULL,
      '22221140',
      '02034314',
      NULL,
      '40013132',
      NULL,
      '44324300',
      NULL,
      '30001240',
      '30200113',
      '42402031',
      '01101243',
      NULL,
      '04433014',
      '33401200',
      NULL,
      '03403111',
      '21242122',
      '21124400',
      '34032433',
      NULL,
      NULL,
      '12414333',
      '42321141',
      '20222010',
      '10302003',
      '23233222',
      '43311430',
      '10320001',
      '30230034',
      '02421040',
      NULL,
      '31',
      NULL,
      NULL,
      '0442443',
      0,
      0.126821,
      NULL,
      NULL,
      '123142',
      1,
      ' 8-27-1976',
      ' 1- 7-1977',
      NULL,
      NULL,
      6.374612,
      6.913930,
      34.396487,
      10.547644,
      66.607166,
      0.502341,
      11.718136,
      NULL,
      22,
      18.928586,
      15.294589,
      15.871250,
      26,
      NULL,
      0.740942,
      17,
      51.830180,
      5,
      66,
      11,
      116,
      18,
      NULL,
      84,
      171,
      35.672549,
      6.849456,
      230,
      126.997563,
      ' 0-28-1997',
      32.649205,
      20,
      4.963389,
      9.176527,
      80,
      109.290400,
      ' 1- 3-2000',
      NULL,
      3,
      NULL,
      0,
      1,
      1.045259,
      1,
      1.634534,
      1.187491,
      NULL,
      NULL,
      0.997340,
      NULL,
      0.337064,
      1.916801,
      0.823452,
      3.178572,
      NULL,
      1.774552,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-21-1975',
      93,
      4,
      13,
      1.566954,
      14,
      8.814793,
      ' 4- 6-2003',
      0,
      1.591486,
      159.336125,
      1,
      2,
      10.427418,
      1,
      1,
      4,
      1,
      3.311228,
      NULL,
      NULL,
      NULL,
      52.115437,
      51,
      25,
      14,
      9.170650,
      33.176993,
      2.930687,
      46.094325,
      40,
      78,
      59,
      ' 8-16-1978',
      10,
      NULL,
      1,
      36.963364,
      35.290452,
      109.866469,
      9.381875,
      ' 4-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.158593,
      2.510689,
      ' 8- 4-1997',
      198.927564,
      3,
      ' 0-27-1996',
      24,
      1.355239,
      ' 5-10-1990',
      15,
      ' 6-16-1991',
      NULL,
      ' 8-11-1981',
      6,
      16.978369,
      ' 1-28-1999',
      53,
      41,
      ' 2- 6-1982',
      NULL,
      1,
      ' 3- 1-1983',
      0,
      9.001817,
      ' 3- 2-1983',
      2,
      1,
      24,
      ' 8-17-1989',
      13.972563,
      31.598181,
      46,
      '10- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9);
commit;
end;
/


