set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127905';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2100',
      '22423124',
      '03423401',
      '22132211',
      '44241210',
      NULL,
      '13114020',
      NULL,
      '23403021',
      '30112342',
      '13301202',
      '31200210',
      '00240021',
      NULL,
      '44404244',
      NULL,
      NULL,
      '14101041',
      '14332131',
      '14043243',
      '21101420',
      '12201321',
      NULL,
      '34101241',
      '10120334',
      NULL,
      '20302013',
      '30413441',
      '10010432',
      '33212430',
      '23243320',
      '03413041',
      '22120413',
      '04103133',
      '01342124',
      '24040034',
      '03402223',
      '21212221',
      '32212004',
      '24401011',
      '11244142',
      '03040031',
      '31122332',
      '32343111',
      '31243231',
      '223',
      '03',
      NULL,
      NULL,
      '2304404',
      1.481784,
      1,
      0,
      NULL,
      '430222',
      2,
      ' 7-11-1991',
      ' 0-28-1992',
      58,
      NULL,
      2.176485,
      13.020999,
      40,
      20,
      53,
      2.050052,
      15.228811,
      NULL,
      45.843867,
      20,
      28.103431,
      2.235679,
      NULL,
      1,
      7.740436,
      15.333947,
      19,
      4,
      NULL,
      5,
      77,
      18,
      0,
      10,
      113,
      79.112395,
      147.303385,
      91.465025,
      125.249438,
      ' 5-13-1989',
      44.097774,
      49,
      5,
      3,
      NULL,
      67.752376,
      ' 2- 2-1985',
      2,
      NULL,
      NULL,
      3,
      1,
      1.310833,
      2,
      1,
      0.336421,
      0.326040,
      3.903940,
      1,
      1,
      1,
      0.401144,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817745,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-25-1993',
      18,
      8,
      3.055269,
      5.890389,
      7.912232,
      5.892076,
      ' 0- 7-1985',
      1,
      1,
      180,
      1,
      1.888540,
      175.284735,
      1,
      1,
      NULL,
      1.815360,
      2,
      164.728964,
      ' 8-21-1976',
      86.154825,
      97.199719,
      73,
      41.480121,
      8,
      86.462614,
      16,
      62.138433,
      28.161536,
      21.589152,
      68,
      NULL,
      NULL,
      15,
      14.617847,
      NULL,
      16.890615,
      73.517319,
      47.470330,
      8,
      '11- 3-1994',
      23.072281,
      NULL,
      ' 5-19-1984',
      7,
      NULL,
      18.104771,
      10.260045,
      18.992829,
      2,
      0.555271,
      27.062432,
      1.300501,
      2,
      1.603705,
      NULL,
      7,
      19,
      0.020092,
      NULL,
      0,
      0,
      NULL,
      5,
      3.649468,
      0.804961,
      ' 5-28-1978',
      93,
      7,
      ' 4- 7-1992',
      34,
      24.202055,
      ' 6-11-1983',
      4.067321,
      '10-29-1981',
      5.099565,
      ' 9-17-1978',
      4.489390,
      16,
      ' 6- 8-1995',
      62,
      NULL,
      '11-23-1978',
      5.263070,
      21.785850,
      ' 2-20-1994',
      2.153590,
      2,
      ' 0-26-1979',
      0,
      1,
      1.871225,
      ' 0- 1-1981',
      58.849775,
      24,
      21.520517,
      '10- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


