set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130',
      NULL,
      '21041113',
      '43334111',
      '32443332',
      '31030144',
      '32132021',
      '02201313',
      NULL,
      '22314320',
      '10312324',
      '01403034',
      '21341331',
      '03311044',
      '32103234',
      '10204401',
      '34144011',
      '21112141',
      NULL,
      '13121434',
      NULL,
      '34311212',
      NULL,
      '41141223',
      '21102113',
      '03013200',
      '11321113',
      '02103430',
      '41021400',
      NULL,
      '44111020',
      NULL,
      '14032313',
      '40124340',
      '41200100',
      '30300000',
      '41222434',
      '12344200',
      NULL,
      '23234303',
      '01043331',
      '22303013',
      '23214342',
      '22131210',
      '40323040',
      '',
      '',
      NULL,
      NULL,
      '1012403',
      2.340623,
      NULL,
      0,
      NULL,
      '144141',
      3,
      ' 1-10-2003',
      '11- 3-1989',
      5,
      NULL,
      13.641260,
      18,
      22.931543,
      14,
      52,
      10,
      17,
      NULL,
      16.682715,
      NULL,
      37.384748,
      6,
      NULL,
      20,
      11.314659,
      26,
      NULL,
      11,
      56,
      21.215371,
      74.166266,
      8,
      NULL,
      110,
      24.563733,
      NULL,
      7.858984,
      NULL,
      82.786932,
      ' 4-23-1981',
      54.359710,
      60.830020,
      21,
      NULL,
      93,
      184,
      ' 4- 1-1974',
      0.149309,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909000,
      0.395611,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1990',
      66.542670,
      56,
      39.506390,
      38.351418,
      38.394343,
      28.729699,
      57.138574,
      NULL,
      90.674123,
      22.351561,
      99.067851,
      0,
      '11-29-1974',
      0.901143,
      23.908589,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1989',
      7,
      9.934326,
      ' 8-19-1989',
      7,
      1.149103,
      14,
      16,
      8,
      2,
      NULL,
      18.773509,
      NULL,
      NULL,
      0.032697,
      0.318495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68.520042,
      8,
      NULL,
      ' 6- 5-1994',
      NULL,
      100,
      ' 3- 5-2000',
      0,
      24,
      NULL,
      10.211796,
      NULL,
      10.546638,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.280558,
      NULL,
      NULL,
      39.983031,
      15,
      0,
      3,
      11.438479,
      2,
      4,
      8,
      29,
      NULL,
      NULL,
      61.727139,
      0.850870,
      0.441447,
      40,
      1.091390,
      2.972925,
      NULL,
      NULL,
      3,
      67.130914,
      0.804342,
      3,
      56.659147,
      NULL,
      NULL,
      1.485924,
      NULL,
      NULL,
      1,
      1,
      0.490360,
      16,
      35.237226,
      NULL,
      NULL,
      69,
      37.927626,
      1.422063,
      1,
      21.538170,
      NULL,
      1,
      NULL,
      8,
      0,
      39,
      1.714686,
      31,
      0,
      NULL,
      83.492516,
      25.392943,
      9.869604,
      13,
      46,
      18,
      7.009652,
      23,
      9,
      8,
      1,
      0.435113,
      3.656626,
      0,
      1,
      3,
      50.073725,
      ' 7-18-1988',
      '10- 1-1985',
      ' 5- 0-1998',
      ' 1-28-1999',
      ' 4-13-1986',
      ' 7- 8-1987',
      ' 9- 6-1982',
      NULL);
commit;
end;
/


