set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2134',
      '43203320',
      '40410333',
      '03224000',
      '11333023',
      '33211344',
      '21130201',
      '14342330',
      NULL,
      '11342002',
      '31214414',
      '03241322',
      '31223223',
      '14213430',
      '03221334',
      '01023334',
      '13422013',
      '03413221',
      '14443420',
      '43104443',
      NULL,
      '40234332',
      '03333024',
      '23433441',
      '01132130',
      '40432243',
      '30433441',
      NULL,
      '03044344',
      '14241421',
      NULL,
      '44224320',
      '43343430',
      '14202010',
      '01334444',
      NULL,
      '01421420',
      '30212021',
      '00324234',
      '32104443',
      '41330410',
      '44101041',
      '10240221',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4310302',
      3.107928,
      23.548604,
      NULL,
      NULL,
      '211042',
      NULL,
      ' 8- 6-1977',
      ' 5-24-2001',
      12.300377,
      NULL,
      42,
      8,
      20,
      5.762287,
      94.838576,
      NULL,
      18,
      9,
      NULL,
      17.423068,
      0.005365,
      NULL,
      NULL,
      16.680882,
      NULL,
      3.564975,
      8,
      0.963771,
      50,
      2.404155,
      58,
      8,
      NULL,
      35,
      128,
      26,
      101,
      60.676172,
      172,
      ' 5-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928681,
      2,
      0.038107,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.501836,
      NULL,
      1.823148,
      0.396398,
      1.628361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1982',
      93.360070,
      44,
      83,
      43.066176,
      NULL,
      45,
      68.351622,
      59,
      6,
      68,
      NULL,
      NULL,
      ' 5- 3-1988',
      10.251517,
      6.387004,
      6.349877,
      0,
      32,
      8,
      4.937828,
      ' 4-14-2000',
      4,
      11,
      NULL,
      8.736089,
      9.775089,
      NULL,
      NULL,
      12.279721,
      NULL,
      NULL,
      25,
      NULL,
      68.530304,
      0,
      3,
      1.845552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      28.546305,
      NULL,
      ' 7-22-1992',
      0,
      103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      51,
      71.828260,
      16.039323,
      4,
      NULL,
      6.988796,
      4.783074,
      NULL,
      NULL,
      0,
      0,
      94,
      NULL,
      0,
      NULL,
      1,
      1,
      48.119751,
      NULL,
      1.609789,
      NULL,
      1.143321,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.461876,
      1,
      1,
      50,
      NULL,
      11.329827,
      12,
      NULL,
      30.522664,
      NULL,
      NULL,
      2,
      11.834075,
      NULL,
      3,
      1,
      0.140022,
      0,
      NULL,
      71.465257,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1987',
      NULL,
      ' 0-19-1980',
      NULL);
commit;
end;
/


