set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0413',
      NULL,
      '31032400',
      '14112200',
      '02421120',
      '31101231',
      '40214411',
      '23031030',
      NULL,
      '21121033',
      '11000230',
      '31114123',
      '13104102',
      NULL,
      '44111310',
      NULL,
      '31104020',
      '34334131',
      NULL,
      '12401421',
      '44410200',
      '30233414',
      '11312234',
      '21312012',
      '13130143',
      '02301423',
      '12334244',
      '23313104',
      '21441003',
      NULL,
      NULL,
      '13403311',
      '00224000',
      NULL,
      '43131140',
      '23212341',
      '23401214',
      NULL,
      '23321444',
      '11020410',
      '41204420',
      '04411043',
      NULL,
      NULL,
      NULL,
      '034',
      '43',
      10.788253,
      0.900762,
      '0142031',
      1,
      84,
      2,
      NULL,
      '333443',
      5.169610,
      ' 6-20-1997',
      ' 5-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      11.698125,
      81.168191,
      NULL,
      5,
      3.770419,
      NULL,
      1.743422,
      7,
      10.826424,
      29.681771,
      NULL,
      12,
      NULL,
      40,
      8,
      36.644106,
      26,
      27.552555,
      5.559575,
      1,
      48.799880,
      155.792428,
      71.621407,
      47.068471,
      190,
      90.100847,
      ' 4-18-2002',
      0.312725,
      67.550638,
      32.632662,
      7.410333,
      187,
      NULL,
      ' 1- 5-1977',
      0.247767,
      0,
      3,
      0.732242,
      4,
      1.068048,
      3,
      0,
      0,
      0.370108,
      0,
      0.521657,
      0,
      NULL,
      0.817144,
      0.777379,
      1.501643,
      NULL,
      1.898046,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      5,
      1,
      8,
      5,
      0,
      NULL,
      0.205902,
      NULL,
      57.397668,
      3.718112,
      NULL,
      18,
      1.660115,
      0.809229,
      97,
      NULL,
      NULL,
      NULL,
      ' 7-12-1977',
      44.108991,
      93.030100,
      100.385657,
      48.006134,
      NULL,
      50.840719,
      44,
      72.032581,
      29.957617,
      71.498893,
      2.035039,
      49,
      ' 6-24-1983',
      18,
      4.215720,
      NULL,
      15.118834,
      NULL,
      18,
      7.677179,
      NULL,
      30.839837,
      7.924429,
      ' 3-17-1974',
      4.229439,
      12.930034,
      NULL,
      19.334572,
      16.121692,
      4,
      0,
      19,
      NULL,
      75,
      0.899283,
      1,
      17,
      13,
      0.933938,
      1,
      0.792482,
      1.824229,
      '10-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      179.411838,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      '10-27-1998',
      3.441513,
      13,
      '11-28-2000',
      NULL,
      NULL,
      ' 6-20-1983',
      1.941469,
      1.629620,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      12,
      ' 2-22-1988',
      41,
      24,
      NULL,
      '11-12-1992',
      1.492932,
      71,
      NULL,
      8,
      3.902331,
      14,
      11,
      ' 3-10-2003',
      51,
      NULL,
      7.141427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


