set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1100',
      NULL,
      '23433313',
      '32324041',
      '13114334',
      '42014300',
      '04144342',
      '20012111',
      '10004400',
      '42311112',
      '10021402',
      '32014204',
      '10034103',
      '33423021',
      '04134400',
      '13141411',
      '44020102',
      '30241441',
      '24212414',
      '22311302',
      NULL,
      '02040421',
      NULL,
      '01310300',
      '40202113',
      '13131230',
      '03034410',
      '34043112',
      '40214032',
      '22411102',
      NULL,
      NULL,
      '24122203',
      '10411212',
      '13224111',
      '40114242',
      '01400004',
      '44234221',
      '02102024',
      '33000142',
      '11402434',
      NULL,
      '42210014',
      '41041334',
      '02431440',
      '134',
      '13',
      31.776921,
      1.620101,
      '1012202',
      2,
      143.665682,
      NULL,
      NULL,
      NULL,
      1.805770,
      NULL,
      ' 6-23-1994',
      190,
      NULL,
      13,
      10.523596,
      9,
      NULL,
      9,
      14,
      6.801502,
      3,
      10.550797,
      2.348396,
      9,
      11.773971,
      NULL,
      NULL,
      4.919904,
      4.197078,
      34.800063,
      0,
      27,
      NULL,
      NULL,
      10.057341,
      0,
      50.565067,
      36.159459,
      92.122663,
      151.348232,
      139.800107,
      85.639988,
      ' 0-17-1975',
      28.515641,
      28.965843,
      31.406784,
      NULL,
      NULL,
      167,
      ' 7-26-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.653431,
      4,
      0.023821,
      0.311808,
      7,
      NULL,
      ' 9-22-1976',
      0.657304,
      NULL,
      179,
      2.725631,
      NULL,
      36.271966,
      1.043408,
      1.043136,
      34.610359,
      NULL,
      NULL,
      NULL,
      '10-14-1979',
      NULL,
      NULL,
      42,
      57.386706,
      17.406052,
      NULL,
      44,
      38,
      0,
      NULL,
      NULL,
      21.236355,
      ' 9-21-1999',
      29.723464,
      NULL,
      15,
      43,
      NULL,
      NULL,
      6.788709,
      ' 8-27-1987',
      19,
      NULL,
      '11-18-1978',
      10.090820,
      8.465694,
      7,
      21,
      6,
      2,
      0.829577,
      11,
      0,
      NULL,
      0.315616,
      4.425372,
      10,
      1,
      NULL,
      0.106734,
      0.354161,
      3.025105,
      ' 1-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1988',
      NULL,
      NULL,
      NULL,
      36.285112,
      NULL,
      NULL,
      ' 2-15-2003',
      9.985472,
      NULL,
      ' 5-12-1975',
      114,
      51.160381,
      ' 7-11-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      16,
      NULL,
      53.990797,
      0.942196,
      19,
      ' 7- 4-1984',
      1,
      33.928331,
      ' 6-11-1999',
      15,
      28,
      23.086113,
      19,
      ' 4-13-1996',
      39,
      0.733711,
      96.736202,
      ' 1- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


