set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8624091';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0320',
      '33430343',
      NULL,
      '23314340',
      '10424323',
      '42423104',
      '24011242',
      '04043444',
      '40110131',
      '01132401',
      '14411320',
      NULL,
      '34341314',
      NULL,
      '14134211',
      '44234333',
      '30010321',
      '10101344',
      '00123420',
      '24204301',
      NULL,
      '23032134',
      '14034140',
      NULL,
      NULL,
      '01130340',
      '42230420',
      '10120221',
      '14101014',
      NULL,
      '31041013',
      '40302310',
      NULL,
      '24242144',
      '32421221',
      NULL,
      '10131123',
      '04334212',
      '13010211',
      '24033221',
      '20142200',
      '01034321',
      NULL,
      '31320410',
      '42132344',
      '',
      '',
      NULL,
      NULL,
      '3442022',
      0,
      NULL,
      NULL,
      NULL,
      '341443',
      2,
      ' 7-28-1984',
      ' 1-11-1987',
      10,
      NULL,
      3,
      2.937741,
      7,
      21,
      30,
      NULL,
      5,
      6.266767,
      0,
      3,
      30.773309,
      31.504955,
      4,
      NULL,
      32,
      27,
      11.737565,
      18,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      109.082209,
      112,
      28,
      NULL,
      172.316256,
      200.042993,
      ' 8-25-1991',
      21,
      29,
      32.917976,
      37,
      36,
      59.314498,
      ' 2- 8-1990',
      NULL,
      1,
      1.711836,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.391960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      25,
      90.424038,
      95,
      2.551060,
      108,
      NULL,
      75.042476,
      61.704527,
      NULL,
      73,
      ' 6-12-1978',
      NULL,
      NULL,
      34.765004,
      66,
      60,
      NULL,
      NULL,
      ' 1-15-1996',
      9,
      NULL,
      ' 4- 8-1991',
      6,
      4,
      5,
      3,
      NULL,
      4,
      NULL,
      18.664505,
      NULL,
      NULL,
      0.280740,
      1,
      6.163087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      37,
      23.920102,
      ' 7- 4-1976',
      NULL,
      99.392665,
      '10- 9-1999',
      12.531264,
      14.940110,
      19.056826,
      5,
      ' 8-21-1977',
      12,
      1.103108,
      29.132262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.576376,
      0.502398,
      12.980662,
      NULL,
      0.201684,
      0,
      NULL,
      1,
      3.076055,
      83.472879,
      0.308187,
      0,
      92,
      NULL,
      NULL,
      138,
      NULL,
      28.228623,
      NULL,
      0,
      NULL,
      0,
      0,
      3.182544,
      1.204292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860453,
      NULL,
      43,
      1,
      3,
      0,
      4,
      0.018602,
      NULL,
      0,
      NULL,
      0.198560,
      0.267978,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      15.322415,
      NULL,
      11.533636,
      6,
      NULL,
      3,
      3.971177,
      2,
      NULL,
      0,
      NULL,
      ' 2-20-1992',
      ' 9-12-1982',
      '10- 8-1983',
      NULL,
      '11-22-1974',
      ' 4-12-2002',
      ' 4-17-2002',
      NULL);
commit;
end;
/


