set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9913006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '4',
      '1',
      '2',
      NULL,
      '0',
      '2',
      '1',
      NULL,
      '1',
      '3',
      '3',
      '4',
      '4',
      '0',
      '4',
      NULL,
      '4',
      '0',
      NULL,
      '1',
      NULL,
      '3',
      '',
      '2',
      '',
      '2',
      '1',
      '4',
      '1',
      NULL,
      '',
      '',
      NULL,
      '4',
      '4',
      '4',
      '3',
      NULL,
      NULL,
      '2',
      '4',
      '2',
      '1',
      '104',
      '23013411',
      NULL,
      73.154127,
      '1434241',
      2,
      1.254402,
      1,
      0,
      '040130',
      3.429856,
      ' 5- 6-1996',
      ' 3-26-1981',
      102,
      NULL,
      36,
      16,
      15.976244,
      NULL,
      8.761276,
      16,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      8.047001,
      2.461353,
      NULL,
      6,
      10.893477,
      4.590755,
      6,
      39.851381,
      2,
      11,
      4,
      1.211664,
      5,
      60.158939,
      48.216704,
      75.972823,
      79.441225,
      68.579025,
      ' 8- 5-1984',
      NULL,
      11.451240,
      21.650941,
      1,
      NULL,
      214,
      ' 9- 4-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.526995,
      70.744260,
      5,
      4,
      71,
      0.102372,
      '11- 0-1990',
      0.288627,
      1,
      157.478705,
      1.195380,
      1.072664,
      40,
      1.475441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1989',
      30,
      50,
      42.500336,
      1.669450,
      NULL,
      13.234760,
      22,
      NULL,
      38,
      51.557522,
      23,
      38.790900,
      ' 4- 7-1987',
      31,
      19,
      1.003667,
      4.548580,
      5.295305,
      134.354684,
      9.736049,
      NULL,
      33,
      8.866618,
      NULL,
      4.672361,
      2,
      3,
      15,
      16,
      NULL,
      1.606979,
      12.564539,
      0.847983,
      57.388701,
      3.572146,
      NULL,
      5,
      NULL,
      1,
      0,
      1.205636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.857776,
      72.899793,
      '10- 4-1995',
      NULL,
      NULL,
      NULL,
      32.285187,
      NULL,
      1.617684,
      ' 0-19-1997',
      2.220879,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      15.364902,
      ' 2-23-2002',
      47,
      17.177701,
      3.538094,
      ' 9- 7-1979',
      1.657332,
      49,
      ' 7-24-2001',
      11,
      8.910099,
      NULL,
      NULL,
      ' 2-21-1982',
      31.132793,
      0,
      97.798291,
      ' 7-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


